/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMap {
    private static final Logger log = LoggerFactory.getLogger(TableMap.class);
    private final Map<String, String> tableNameToIdMap;
    private final Map<String, String> tableIdToNameMap;
    private final ZooCache zooCache;
    private final long updateCount;

    public TableMap(Instance instance, ZooCache zooCache) {
        this.zooCache = zooCache;
        this.updateCount = zooCache.getUpdateCount();
        List tableIds = zooCache.getChildren(ZooUtil.getRoot(instance) + "/tables");
        HashMap<String, String> namespaceIdToNameMap = new HashMap<String, String>();
        ImmutableMap.Builder tableNameToIdBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder tableIdToNameBuilder = new ImmutableMap.Builder();
        StringBuilder zPathBuilder = new StringBuilder();
        zPathBuilder.append(ZooUtil.getRoot(instance)).append("/tables").append("/");
        int prefixLength = zPathBuilder.length();
        for (String tableId : tableIds) {
            String namespaceName;
            byte[] tableName;
            block6: {
                zPathBuilder.setLength(prefixLength);
                zPathBuilder.append(tableId).append("/name");
                tableName = zooCache.get(zPathBuilder.toString());
                zPathBuilder.setLength(prefixLength);
                zPathBuilder.append(tableId).append("/namespace");
                byte[] nId = zooCache.get(zPathBuilder.toString());
                namespaceName = "";
                if (nId == null) {
                    namespaceName = null;
                } else {
                    String namespaceId = new String(nId, StandardCharsets.UTF_8);
                    if (!namespaceId.equals("+default")) {
                        try {
                            namespaceName = (String)namespaceIdToNameMap.get(namespaceId);
                            if (namespaceName != null) break block6;
                            namespaceName = Namespaces.getNamespaceName(instance, namespaceId);
                            namespaceIdToNameMap.put(namespaceId, namespaceName);
                        }
                        catch (NamespaceNotFoundException e) {
                            log.error("Table (" + tableId + ") contains reference to namespace (" + namespaceId + ") that doesn't exist", (Throwable)e);
                            continue;
                        }
                    }
                }
            }
            if (tableName == null || namespaceName == null) continue;
            String tableNameStr = Tables.qualified(new String(tableName, StandardCharsets.UTF_8), namespaceName);
            tableNameToIdBuilder.put((Object)tableNameStr, (Object)tableId);
            tableIdToNameBuilder.put((Object)tableId, (Object)tableNameStr);
        }
        this.tableNameToIdMap = tableNameToIdBuilder.build();
        this.tableIdToNameMap = tableIdToNameBuilder.build();
    }

    public Map<String, String> getNameToIdMap() {
        return this.tableNameToIdMap;
    }

    public Map<String, String> getIdtoNameMap() {
        return this.tableIdToNameMap;
    }

    public boolean isCurrent(ZooCache zc) {
        return this.zooCache == zc && this.updateCount == zc.getUpdateCount();
    }
}

