/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.MutableRegionInfo;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionInfoBuilder {
    public static final String ENCODED_REGION_NAME_REGEX = "(?:[a-f0-9]+)";
    public static final String NO_HASH = null;
    public static final RegionInfo UNDEFINED = RegionInfoBuilder.newBuilder(TableName.valueOf("__UNDEFINED__")).build();
    public static final RegionInfo FIRST_META_REGIONINFO = new MutableRegionInfo(1L, TableName.META_TABLE_NAME, 0);
    private final TableName tableName;
    private byte[] startKey = HConstants.EMPTY_START_ROW;
    private byte[] endKey = HConstants.EMPTY_END_ROW;
    private long regionId = System.currentTimeMillis();
    private int replicaId = 0;
    private boolean offLine = false;
    private boolean split = false;

    public static RegionInfoBuilder newBuilder(TableName tableName) {
        return new RegionInfoBuilder(tableName);
    }

    public static RegionInfoBuilder newBuilder(RegionInfo regionInfo) {
        return new RegionInfoBuilder(regionInfo);
    }

    private RegionInfoBuilder(TableName tableName) {
        this.tableName = tableName;
    }

    private RegionInfoBuilder(RegionInfo regionInfo) {
        this.tableName = regionInfo.getTable();
        this.startKey = regionInfo.getStartKey();
        this.endKey = regionInfo.getEndKey();
        this.offLine = regionInfo.isOffline();
        this.split = regionInfo.isSplit();
        this.regionId = regionInfo.getRegionId();
        this.replicaId = regionInfo.getReplicaId();
    }

    public RegionInfoBuilder setStartKey(byte[] startKey) {
        this.startKey = startKey;
        return this;
    }

    public RegionInfoBuilder setEndKey(byte[] endKey) {
        this.endKey = endKey;
        return this;
    }

    public RegionInfoBuilder setRegionId(long regionId) {
        this.regionId = regionId;
        return this;
    }

    public RegionInfoBuilder setReplicaId(int replicaId) {
        this.replicaId = replicaId;
        return this;
    }

    public RegionInfoBuilder setSplit(boolean split) {
        this.split = split;
        return this;
    }

    @Deprecated
    public RegionInfoBuilder setOffline(boolean offLine) {
        this.offLine = offLine;
        return this;
    }

    public RegionInfo build() {
        return new MutableRegionInfo(this.tableName, this.startKey, this.endKey, this.split, this.regionId, this.replicaId, this.offLine);
    }
}

