/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.scheduler.AsyncEventQueue;
import org.apache.spark.scheduler.LiveListenerBus$;
import org.apache.spark.scheduler.LiveListenerBusMetrics;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.DynamicVariable;

@ScalaSignature(bytes="\u0006\u0001\t%d!B\u001a5\u0001Yb\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b%\u0003A\u0011\u0001&\t\u00139\u0003\u0001\u0019!a\u0001\n\u0013y\u0005\"C*\u0001\u0001\u0004\u0005\r\u0011\"\u0003U\u0011%Q\u0006\u00011A\u0001B\u0003&\u0001\u000b\u0003\u0005\\\u0001\t\u0007I\u0011\u0001\u001c]\u0011\u0019\u0001\u0007\u0001)A\u0005;\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007BB8\u0001A\u0003%1\rC\u0004q\u0001\t\u0007I\u0011\u00022\t\rE\u0004\u0001\u0015!\u0003d\u0011\u001d\u0011\bA1A\u0005\nMDaa\u001e\u0001!\u0002\u0013!\bb\u0002=\u0001\u0001\u0004%I!\u001f\u0005\b{\u0002\u0001\r\u0011\"\u0003\u007f\u0011\u001d\t\t\u0001\u0001Q!\niD\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u001fA!\"a\b\u0001\u0001\u0004%\t\u0001NA\u0011\u0011)\tI\u0004\u0001a\u0001\n\u0003!\u00141\b\u0005\t\u0003\u007f\u0001\u0001\u0015)\u0003\u0002$!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\ti\u0006\u0001C\u0001\u0003?B\u0001\"a\u0019\u0001\t\u00031\u0014Q\r\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!!%\u0001\t\u0013\t\u0019\nC\u0004\u0002\u0018\u0002!\t!!'\t\u0011\u00055\u0006\u0001\"\u00017\u0003_Cq!!,\u0001\t\u0003\t\t\rC\u0004\u0002J\u0002!\t!a,\t\u0011\u0005-\u0007\u0001\"\u00017\u0003\u001bD\u0001B!\u0002\u0001\t\u00031$q\u0001\u0005\t\u0005#\u0001A\u0011\u0001\u001b\u0003\u0014!A!1\u0004\u0001\u0005\u0002Q\u0012ib\u0002\u0005\u00030QB\tA\u000eB\u0019\r\u001d\u0019D\u0007#\u00017\u0005gAa!S\u0014\u0005\u0002\tU\u0002\"\u0003B\u001cO\t\u0007I\u0011\u0001B\u001d\u0011!\u0011Ye\nQ\u0001\n\tm\u0002B\u0003B'O\t\u0007I\u0011\u0001\u001b\u0003P!A!1L\u0014!\u0002\u0013\u0011\t\u0006\u0003\u0006\u0003^\u001d\u0012\r\u0011\"\u00015\u0005\u001fB\u0001Ba\u0018(A\u0003%!\u0011\u000b\u0005\u000b\u0005C:#\u0019!C\u0001i\t=\u0003\u0002\u0003B2O\u0001\u0006IA!\u0015\t\u0015\t\u0015tE1A\u0005\u0002Q\u0012y\u0005\u0003\u0005\u0003h\u001d\u0002\u000b\u0011\u0002B)\u0005=a\u0015N^3MSN$XM\\3s\u0005V\u001c(BA\u001b7\u0003%\u00198\r[3ek2,'O\u0003\u00028q\u0005)1\u000f]1sW*\u0011\u0011HO\u0001\u0007CB\f7\r[3\u000b\u0003m\n1a\u001c:h'\t\u0001Q\b\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004B]f\u0014VMZ\u0001\u0005G>tgm\u0001\u0001\u0011\u0005\u0019;U\"\u0001\u001c\n\u0005!3$!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u00111*\u0014\t\u0003\u0019\u0002i\u0011\u0001\u000e\u0005\u0006\u0007\n\u0001\r!R\u0001\rgB\f'o[\"p]R,\u0007\u0010^\u000b\u0002!B\u0011a)U\u0005\u0003%Z\u0012Ab\u00159be.\u001cuN\u001c;fqR\f\u0001c\u001d9be.\u001cuN\u001c;fqR|F%Z9\u0015\u0005UC\u0006C\u0001 W\u0013\t9vH\u0001\u0003V]&$\bbB-\u0005\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\n\u0014!D:qCJ\\7i\u001c8uKb$\b%A\u0004nKR\u0014\u0018nY:\u0016\u0003u\u0003\"\u0001\u00140\n\u0005}#$A\u0006'jm\u0016d\u0015n\u001d;f]\u0016\u0014()^:NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nqa\u001d;beR,G-F\u0001d!\t!W.D\u0001f\u0015\t1w-\u0001\u0004bi>l\u0017n\u0019\u0006\u0003Q&\f!bY8oGV\u0014(/\u001a8u\u0015\tQ7.\u0001\u0003vi&d'\"\u00017\u0002\t)\fg/Y\u0005\u0003]\u0016\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001C:uCJ$X\r\u001a\u0011\u0002\u000fM$x\u000e\u001d9fI\u0006A1\u000f^8qa\u0016$\u0007%\u0001\u000bee>\u0004\b/\u001a3Fm\u0016tGo]\"pk:$XM]\u000b\u0002iB\u0011A-^\u0005\u0003m\u0016\u0014!\"\u0011;p[&\u001cGj\u001c8h\u0003U!'o\u001c9qK\u0012,e/\u001a8ug\u000e{WO\u001c;fe\u0002\n1\u0003\\1tiJ+\u0007o\u001c:u)&lWm\u001d;b[B,\u0012A\u001f\t\u0003}mL!\u0001` \u0003\t1{gnZ\u0001\u0018Y\u0006\u001cHOU3q_J$H+[7fgR\fW\u000e]0%KF$\"!V@\t\u000fe{\u0011\u0011!a\u0001u\u0006!B.Y:u%\u0016\u0004xN\u001d;US6,7\u000f^1na\u0002B3\u0001EA\u0003!\rq\u0014qA\u0005\u0004\u0003\u0013y$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\rE,X-^3t+\t\ty\u0001\u0005\u0004\u0002\u0012\u0005M\u0011qC\u0007\u0002O&\u0019\u0011QC4\u0003)\r{\u0007/_(o/JLG/Z!se\u0006LH*[:u!\ra\u0015\u0011D\u0005\u0004\u00037!$aD!ts:\u001cWI^3oiF+X-^3\u0002\u000fE,X-^3tA\u0005a\u0011/^3vK\u0012,e/\u001a8ugV\u0011\u00111\u0005\t\u0007\u0003K\ty#a\r\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tq!\\;uC\ndWMC\u0002\u0002.}\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t$a\n\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000fE\u0002M\u0003kI1!a\u000e5\u0005I\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u00163XM\u001c;\u0002!E,X-^3e\u000bZ,g\u000e^:`I\u0015\fHcA+\u0002>!A\u0011\fFA\u0001\u0002\u0004\t\u0019#A\u0007rk\u0016,X\rZ#wK:$8\u000f\t\u0015\u0004+\u0005\u0015\u0011\u0001E1eIR{7\u000b[1sK\u0012\fV/Z;f)\r)\u0016q\t\u0005\b\u0003\u00132\u0002\u0019AA&\u0003!a\u0017n\u001d;f]\u0016\u0014\bc\u0001'\u0002N%\u0019\u0011q\n\u001b\u0003-M\u0003\u0018M]6MSN$XM\\3s\u0013:$XM\u001d4bG\u0016\fA#\u00193e)>l\u0015M\\1hK6,g\u000e^)vKV,GcA+\u0002V!9\u0011\u0011J\fA\u0002\u0005-\u0013\u0001E1eIR{7\u000b^1ukN\fV/Z;f)\r)\u00161\f\u0005\b\u0003\u0013B\u0002\u0019AA&\u0003I\tG\r\u001a+p\u000bZ,g\u000e\u001e'pOF+X-^3\u0015\u0007U\u000b\t\u0007C\u0004\u0002Je\u0001\r!a\u0013\u0002\u0015\u0005$G\rV8Rk\u0016,X\rF\u0003V\u0003O\nI\u0007C\u0004\u0002Ji\u0001\r!a\u0013\t\u000f\u0005-$\u00041\u0001\u0002n\u0005)\u0011/^3vKB!\u0011qNA?\u001d\u0011\t\t(!\u001f\u0011\u0007\u0005Mt(\u0004\u0002\u0002v)\u0019\u0011q\u000f#\u0002\rq\u0012xn\u001c;?\u0013\r\tYhP\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0014\u0011\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mt(\u0001\bsK6|g/\u001a'jgR,g.\u001a:\u0015\u0007U\u000b9\tC\u0004\u0002Jm\u0001\r!a\u0013\u0002\tA|7\u000f\u001e\u000b\u0004+\u00065\u0005bBAH9\u0001\u0007\u00111G\u0001\u0006KZ,g\u000e^\u0001\ra>\u001cH\u000fV8Rk\u0016,Xm\u001d\u000b\u0004+\u0006U\u0005bBAH;\u0001\u0007\u00111G\u0001\u0006gR\f'\u000f\u001e\u000b\u0006+\u0006m\u0015q\u0014\u0005\u0007\u0003;s\u0002\u0019\u0001)\u0002\u0005M\u001c\u0007bBAQ=\u0001\u0007\u00111U\u0001\u000e[\u0016$(/[2t'f\u001cH/Z7\u0011\t\u0005\u0015\u0016\u0011V\u0007\u0003\u0003OS!a\u0017\u001c\n\t\u0005-\u0016q\u0015\u0002\u000e\u001b\u0016$(/[2t'f\u001cH/Z7\u0002\u001d]\f\u0017\u000e^+oi&dW)\u001c9usR\tQ\u000bK\u0003 \u0003g\u000by\fE\u0003?\u0003k\u000bI,C\u0002\u00028~\u0012a\u0001\u001e5s_^\u001c\b\u0003BA\t\u0003wK1!!0h\u0005A!\u0016.\\3pkR,\u0005pY3qi&|gn\t\u0002\u0002:R\u0019Q+a1\t\r\u0005\u0015\u0007\u00051\u0001{\u00035!\u0018.\\3pkRl\u0015\u000e\u001c7jg\"*\u0001%a-\u0002@\u0006!1\u000f^8q\u0003Q1\u0017N\u001c3MSN$XM\\3sg\nK8\t\\1tgV!\u0011qZAu)\t\t\t\u000e\u0006\u0003\u0002T\u0006U\bCBAk\u0003?\f)O\u0004\u0003\u0002X\u0006mg\u0002BA:\u00033L\u0011\u0001Q\u0005\u0004\u0003;|\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003C\f\u0019OA\u0002TKFT1!!8@!\u0011\t9/!;\r\u0001\u00119\u00111\u001e\u0012C\u0002\u00055(!\u0001+\u0012\t\u0005=\u00181\n\t\u0004}\u0005E\u0018bAAz\u007f\t9aj\u001c;iS:<\u0007\"CA|E\u0005\u0005\t9AA}\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003w\u0014\t!!:\u000e\u0005\u0005u(bAA\u0000\u007f\u00059!/\u001a4mK\u000e$\u0018\u0002\u0002B\u0002\u0003{\u0014\u0001b\u00117bgN$\u0016mZ\u0001\nY&\u001cH/\u001a8feN,\"A!\u0003\u0011\r\t-!QBA&\u001b\u0005I\u0017b\u0001B\bS\n!A*[:u\u00031\t7\r^5wKF+X-^3t)\t\u0011)\u0002\u0005\u0004\u0002p\t]\u0011QN\u0005\u0005\u00053\t\tIA\u0002TKR\f\u0001cZ3u#V,W/Z\"ba\u0006\u001c\u0017\u000e^=\u0015\t\t}!1\u0006\t\u0006}\t\u0005\"QE\u0005\u0004\u0005Gy$AB(qi&|g\u000eE\u0002?\u0005OI1A!\u000b@\u0005\rIe\u000e\u001e\u0005\b\u0005[)\u0003\u0019AA7\u0003\u0011q\u0017-\\3\u0002\u001f1Kg/\u001a'jgR,g.\u001a:CkN\u0004\"\u0001T\u0014\u0014\u0005\u001djDC\u0001B\u0019\u0003Q9\u0018\u000e\u001e5j]2K7\u000f^3oKJ$\u0006N]3bIV\u0011!1\b\t\u0007\u0005{\u0011\tE!\u0012\u000e\u0005\t}\"B\u00016@\u0013\u0011\u0011\u0019Ea\u0010\u0003\u001f\u0011Kh.Y7jGZ\u000b'/[1cY\u0016\u00042A\u0010B$\u0013\r\u0011Ie\u0010\u0002\b\u0005>|G.Z1o\u0003U9\u0018\u000e\u001e5j]2K7\u000f^3oKJ$\u0006N]3bI\u0002\nAb\u0015%B%\u0016#u,U+F+\u0016+\"A!\u0015\u0011\t\tM#\u0011L\u0007\u0003\u0005+R1Aa\u0016l\u0003\u0011a\u0017M\\4\n\t\u0005}$QK\u0001\u000e'\"\u000b%+\u0012#`#V+U+\u0012\u0011\u0002!\u0005\u0003\u0006kX*U\u0003R+6kX)V\u000bV+\u0015!E!Q!~\u001bF+\u0011+V'~\u000bV+R+FA\u0005IR\tW#D+R{%kX'B\u001d\u0006;U)T#O)~\u000bV+R+F\u0003i)\u0005,R\"V)>\u0013v,T!O\u0003\u001e+U*\u0012(U?F+V)V#!\u0003=)e+\u0012(U?2{uiX)V\u000bV+\u0015\u0001E#W\u000b:#v\fT(H?F+V)V#!\u0001")
public class LiveListenerBus {
    private final SparkConf conf;
    private SparkContext sparkContext;
    private final LiveListenerBusMetrics metrics;
    private final AtomicBoolean started;
    private final AtomicBoolean stopped;
    private final AtomicLong droppedEventsCounter;
    private volatile long lastReportTimestamp;
    private final CopyOnWriteArrayList<AsyncEventQueue> queues;
    private volatile ListBuffer<SparkListenerEvent> queuedEvents;

    public static DynamicVariable<Object> withinListenerThread() {
        return LiveListenerBus$.MODULE$.withinListenerThread();
    }

    private SparkContext sparkContext() {
        return this.sparkContext;
    }

    private void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public LiveListenerBusMetrics metrics() {
        return this.metrics;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private AtomicLong droppedEventsCounter() {
        return this.droppedEventsCounter;
    }

    private long lastReportTimestamp() {
        return this.lastReportTimestamp;
    }

    private void lastReportTimestamp_$eq(long x$1) {
        this.lastReportTimestamp = x$1;
    }

    private CopyOnWriteArrayList<AsyncEventQueue> queues() {
        return this.queues;
    }

    public ListBuffer<SparkListenerEvent> queuedEvents() {
        return this.queuedEvents;
    }

    public void queuedEvents_$eq(ListBuffer<SparkListenerEvent> x$1) {
        this.queuedEvents = x$1;
    }

    public void addToSharedQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.SHARED_QUEUE());
    }

    public void addToManagementQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.EXECUTOR_MANAGEMENT_QUEUE());
    }

    public void addToStatusQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.APP_STATUS_QUEUE());
    }

    public void addToEventLogQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.EVENT_LOG_QUEUE());
    }

    public void addToQueue(SparkListenerInterface listener, String queue) {
        LiveListenerBus liveListenerBus = this;
        synchronized (liveListenerBus) {
            if (this.stopped().get()) {
                throw new IllegalStateException("LiveListenerBus is stopped.");
            }
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LiveListenerBus.$anonfun$addToQueue$1(queue, x$1)));
            if (option instanceof Some) {
                Some some = (Some)option;
                AsyncEventQueue queue2 = (AsyncEventQueue)some.value();
                queue2.addListener(listener);
            } else if (None$.MODULE$.equals(option)) {
                AsyncEventQueue newQueue = new AsyncEventQueue(queue, this.conf, this.metrics(), this);
                newQueue.addListener(listener);
                if (this.started().get()) {
                    newQueue.start(this.sparkContext());
                }
                BoxesRunTime.boxToBoolean((boolean)this.queues().add(newQueue));
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    public synchronized void removeListener(SparkListenerInterface listener) {
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).filter((Function1 & Serializable & scala.Serializable)queue -> BoxesRunTime.boxToBoolean((boolean)LiveListenerBus.$anonfun$removeListener$1(listener, queue)))).foreach((Function1 & Serializable & scala.Serializable)toRemove -> BoxesRunTime.boxToBoolean((boolean)LiveListenerBus.$anonfun$removeListener$2(this, toRemove)));
    }

    public void post(SparkListenerEvent event) {
        block7: {
            if (this.stopped().get()) {
                return;
            }
            this.metrics().numEventsPosted().inc();
            if (this.queuedEvents() == null) {
                this.postToQueues(event);
                return;
            }
            LiveListenerBus liveListenerBus = this;
            synchronized (liveListenerBus) {
                block6: {
                    if (!this.started().get()) {
                        this.queuedEvents().$plus$eq((Object)event);
                        break block6;
                    }
                    break block7;
                }
                return;
            }
        }
        this.postToQueues(event);
    }

    private void postToQueues(SparkListenerEvent event) {
        Iterator<AsyncEventQueue> it = this.queues().iterator();
        while (it.hasNext()) {
            it.next().post(event);
        }
    }

    public synchronized void start(SparkContext sc, MetricsSystem metricsSystem) {
        if (!this.started().compareAndSet(false, true)) {
            throw new IllegalStateException("LiveListenerBus already started.");
        }
        this.sparkContext_$eq(sc);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)q -> {
            LiveListenerBus.$anonfun$start$1(this, sc, q);
            return BoxedUnit.UNIT;
        });
        this.queuedEvents_$eq(null);
        metricsSystem.registerSource(this.metrics());
    }

    public void waitUntilEmpty() throws TimeoutException {
        this.waitUntilEmpty(TimeUnit.SECONDS.toMillis(10L));
    }

    public void waitUntilEmpty(long timeoutMillis) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeoutMillis;
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)queue -> {
            LiveListenerBus.$anonfun$waitUntilEmpty$1(deadline, timeoutMillis, queue);
            return BoxedUnit.UNIT;
        });
    }

    public void stop() {
        if (!this.started().get()) {
            throw new IllegalStateException("Attempted to stop bus that has not yet started!");
        }
        if (!this.stopped().compareAndSet(false, true)) {
            return;
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        this.queues().clear();
    }

    public <T extends SparkListenerInterface> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)queue -> queue.findListenersByClass(evidence$1), Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public List<SparkListenerInterface> listeners() {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.listeners()).asScala(), Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    public Set<String> activeQueues() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public Option<Object> getQueueCapacity(String name) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LiveListenerBus.$anonfun$getQueueCapacity$1(name, x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.capacity()));
    }

    public static final /* synthetic */ boolean $anonfun$addToQueue$1(String queue$1, AsyncEventQueue x$1) {
        String string = x$1.name();
        String string2 = queue$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeListener$1(SparkListenerInterface listener$1, AsyncEventQueue queue) {
        queue.removeListener(listener$1);
        return queue.listeners().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$removeListener$2(LiveListenerBus $this, AsyncEventQueue toRemove) {
        block0: {
            if (!$this.started().get() || $this.stopped().get()) break block0;
            toRemove.stop();
        }
        return $this.queues().remove(toRemove);
    }

    public static final /* synthetic */ void $anonfun$start$1(LiveListenerBus $this, SparkContext sc$1, AsyncEventQueue q) {
        q.start(sc$1);
        $this.queuedEvents().foreach((Function1 & Serializable & scala.Serializable)event -> {
            q.post(event);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilEmpty$1(long deadline$1, long timeoutMillis$1, AsyncEventQueue queue) {
        if (!queue.waitUntilEmpty(deadline$1)) {
            throw SparkCoreErrors$.MODULE$.nonEmptyEventQueueAfterTimeoutError(timeoutMillis$1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getQueueCapacity$1(String name$1, AsyncEventQueue x$5) {
        String string = x$5.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public LiveListenerBus(SparkConf conf) {
        this.conf = conf;
        this.metrics = new LiveListenerBusMetrics(conf);
        this.started = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
        this.droppedEventsCounter = new AtomicLong(0L);
        this.lastReportTimestamp = 0L;
        this.queues = new CopyOnWriteArrayList();
        this.queuedEvents = new ListBuffer();
    }
}

