/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.ipc.AdaptiveLifoCoDelCallQueue;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PluggableRpcQueueNotFound;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.util.BoundedPriorityBlockingQueue;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public abstract class RpcExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RpcExecutor.class);
    protected static final int DEFAULT_CALL_QUEUE_SIZE_HARD_LIMIT = 250;
    public static final String CALL_QUEUE_HANDLER_FACTOR_CONF_KEY = "hbase.ipc.server.callqueue.handler.factor";
    public static final String QUEUE_MAX_CALL_DELAY_CONF_KEY = "hbase.ipc.server.queue.max.call.delay";
    public static final String CALL_QUEUE_TYPE_CODEL_CONF_VALUE = "codel";
    public static final String CALL_QUEUE_TYPE_DEADLINE_CONF_VALUE = "deadline";
    public static final String CALL_QUEUE_TYPE_FIFO_CONF_VALUE = "fifo";
    public static final String CALL_QUEUE_TYPE_PLUGGABLE_CONF_VALUE = "pluggable";
    public static final String CALL_QUEUE_TYPE_CONF_KEY = "hbase.ipc.server.callqueue.type";
    public static final String CALL_QUEUE_TYPE_CONF_DEFAULT = "fifo";
    public static final String CALL_QUEUE_CODEL_TARGET_DELAY = "hbase.ipc.server.callqueue.codel.target.delay";
    public static final String CALL_QUEUE_CODEL_INTERVAL = "hbase.ipc.server.callqueue.codel.interval";
    public static final String CALL_QUEUE_CODEL_LIFO_THRESHOLD = "hbase.ipc.server.callqueue.codel.lifo.threshold";
    public static final int CALL_QUEUE_CODEL_DEFAULT_TARGET_DELAY = 100;
    public static final int CALL_QUEUE_CODEL_DEFAULT_INTERVAL = 100;
    public static final double CALL_QUEUE_CODEL_DEFAULT_LIFO_THRESHOLD = 0.8;
    public static final String PLUGGABLE_CALL_QUEUE_CLASS_NAME = "hbase.ipc.server.callqueue.pluggable.queue.class.name";
    public static final String PLUGGABLE_CALL_QUEUE_WITH_FAST_PATH_ENABLED = "hbase.ipc.server.callqueue.pluggable.queue.fast.path.enabled";
    private LongAdder numGeneralCallsDropped = new LongAdder();
    private LongAdder numLifoModeSwitches = new LongAdder();
    protected final int numCallQueues;
    protected final List<BlockingQueue<CallRunner>> queues;
    private final Class<? extends BlockingQueue> queueClass;
    private final Object[] queueInitArgs;
    private final PriorityFunction priority;
    protected volatile int currentQueueLimit;
    private final AtomicInteger activeHandlerCount = new AtomicInteger(0);
    private final List<Handler> handlers;
    private final int handlerCount;
    private final AtomicInteger failedHandlerCount = new AtomicInteger(0);
    private String name;
    private boolean running;
    private Configuration conf = null;
    private Abortable abortable = null;
    private static QueueBalancer ONE_QUEUE = new QueueBalancer(){

        @Override
        public int getNextQueue() {
            return 0;
        }
    };

    public RpcExecutor(String name, int handlerCount, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        this(name, handlerCount, conf.get(CALL_QUEUE_TYPE_CONF_KEY, "fifo"), maxQueueLength, priority, conf, abortable);
    }

    public RpcExecutor(String name, int handlerCount, String callQueueType, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        this.name = Strings.nullToEmpty(name);
        this.conf = conf;
        this.abortable = abortable;
        float callQueuesHandlersFactor = this.conf.getFloat(CALL_QUEUE_HANDLER_FACTOR_CONF_KEY, 0.1f);
        if (Float.compare(callQueuesHandlersFactor, 1.0f) > 0 || Float.compare(0.0f, callQueuesHandlersFactor) > 0) {
            LOG.warn("hbase.ipc.server.callqueue.handler.factor is *ILLEGAL*, it should be in range [0.0, 1.0]");
            if (Float.compare(callQueuesHandlersFactor, 1.0f) > 0) {
                LOG.warn("Set hbase.ipc.server.callqueue.handler.factor 1.0f");
                callQueuesHandlersFactor = 1.0f;
            } else {
                LOG.warn("Set hbase.ipc.server.callqueue.handler.factor default value 0.0f");
            }
        }
        this.numCallQueues = this.computeNumCallQueues(handlerCount, callQueuesHandlersFactor);
        this.queues = new ArrayList<BlockingQueue<CallRunner>>(this.numCallQueues);
        this.handlerCount = Math.max(handlerCount, this.numCallQueues);
        this.handlers = new ArrayList<Handler>(this.handlerCount);
        this.priority = priority;
        if (RpcExecutor.isDeadlineQueueType(callQueueType)) {
            this.name = this.name + ".Deadline";
            this.queueInitArgs = new Object[]{maxQueueLength, new CallPriorityComparator(conf, this.priority)};
            this.queueClass = BoundedPriorityBlockingQueue.class;
        } else if (RpcExecutor.isCodelQueueType(callQueueType)) {
            this.name = this.name + ".Codel";
            int codelTargetDelay = conf.getInt(CALL_QUEUE_CODEL_TARGET_DELAY, 100);
            int codelInterval = conf.getInt(CALL_QUEUE_CODEL_INTERVAL, 100);
            double codelLifoThreshold = conf.getDouble(CALL_QUEUE_CODEL_LIFO_THRESHOLD, 0.8);
            this.queueInitArgs = new Object[]{maxQueueLength, codelTargetDelay, codelInterval, codelLifoThreshold, this.numGeneralCallsDropped, this.numLifoModeSwitches};
            this.queueClass = AdaptiveLifoCoDelCallQueue.class;
        } else if (RpcExecutor.isPluggableQueueType(callQueueType)) {
            Optional<Class<? extends BlockingQueue<CallRunner>>> pluggableQueueClass = this.getPluggableQueueClass();
            if (!pluggableQueueClass.isPresent()) {
                throw new PluggableRpcQueueNotFound("Pluggable call queue failed to load and selected call queue type required");
            }
            this.queueInitArgs = new Object[]{maxQueueLength, this.priority, conf};
            this.queueClass = pluggableQueueClass.get();
        } else {
            this.name = this.name + ".Fifo";
            this.queueInitArgs = new Object[]{maxQueueLength};
            this.queueClass = LinkedBlockingQueue.class;
        }
        LOG.info("Instantiated {} with queueClass={}; numCallQueues={}, maxQueueLength={}, handlerCount={}", new Object[]{this.name, this.queueClass, this.numCallQueues, maxQueueLength, this.handlerCount});
    }

    protected int computeNumCallQueues(int handlerCount, float callQueuesHandlersFactor) {
        return Math.max(1, Math.round((float)handlerCount * callQueuesHandlersFactor));
    }

    public Map<String, Long> getCallQueueCountsSummary() {
        HashMap<String, Long> callQueueMethodTotalCount = new HashMap<String, Long>();
        for (BlockingQueue<CallRunner> queue : this.queues) {
            for (CallRunner cr : queue) {
                String method;
                RpcCall rpcCall = cr.getRpcCall();
                if (null == rpcCall.getMethod() || StringUtil.isNullOrEmpty(method = rpcCall.getMethod().getName())) {
                    method = "Unknown";
                }
                callQueueMethodTotalCount.put(method, 1L + callQueueMethodTotalCount.getOrDefault(method, 0L));
            }
        }
        return callQueueMethodTotalCount;
    }

    public Map<String, Long> getCallQueueSizeSummary() {
        HashMap<String, Long> callQueueMethodTotalSize = new HashMap<String, Long>();
        for (BlockingQueue<CallRunner> queue : this.queues) {
            for (CallRunner cr : queue) {
                String method;
                RpcCall rpcCall = cr.getRpcCall();
                if (null == rpcCall.getMethod() || StringUtil.isNullOrEmpty(method = rpcCall.getMethod().getName())) {
                    method = "Unknown";
                }
                long size = rpcCall.getSize();
                callQueueMethodTotalSize.put(method, size + callQueueMethodTotalSize.getOrDefault(method, 0L));
            }
        }
        return callQueueMethodTotalSize;
    }

    protected void initializeQueues(int numQueues) {
        if (this.queueInitArgs.length > 0) {
            this.currentQueueLimit = (Integer)this.queueInitArgs[0];
            this.queueInitArgs[0] = Math.max((Integer)this.queueInitArgs[0], 250);
        }
        for (int i = 0; i < numQueues; ++i) {
            this.queues.add(ReflectionUtils.newInstance(this.queueClass, this.queueInitArgs));
        }
    }

    public void start(int port) {
        this.running = true;
        this.startHandlers(port);
    }

    public void stop() {
        this.running = false;
        for (Thread thread : this.handlers) {
            thread.interrupt();
        }
    }

    public abstract boolean dispatch(CallRunner var1) throws InterruptedException;

    protected List<BlockingQueue<CallRunner>> getQueues() {
        return this.queues;
    }

    protected void startHandlers(int port) {
        List<BlockingQueue<CallRunner>> callQueues = this.getQueues();
        this.startHandlers(null, this.handlerCount, callQueues, 0, callQueues.size(), port, this.activeHandlerCount);
    }

    protected Handler getHandler(String name, double handlerFailureThreshhold, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount) {
        return new Handler(name, handlerFailureThreshhold, q, activeHandlerCount);
    }

    protected void startHandlers(String nameSuffix, int numHandlers, List<BlockingQueue<CallRunner>> callQueues, int qindex, int qsize, int port, AtomicInteger activeHandlerCount) {
        String threadPrefix = this.name + Strings.nullToEmpty(nameSuffix);
        double handlerFailureThreshhold = this.conf == null ? 1.0 : this.conf.getDouble("hbase.regionserver.handler.abort.on.error.percent", 0.5);
        for (int i = 0; i < numHandlers; ++i) {
            int index = qindex + i % qsize;
            String name = "RpcServer." + threadPrefix + ".handler=" + this.handlers.size() + ",queue=" + index + ",port=" + port;
            Handler handler = this.getHandler(name, handlerFailureThreshhold, callQueues.get(index), activeHandlerCount);
            handler.start();
            this.handlers.add(handler);
        }
        LOG.debug("Started handlerCount={} with threadPrefix={}, numCallQueues={}, port={}", new Object[]{this.handlers.size(), threadPrefix, qsize, port});
    }

    public static QueueBalancer getBalancer(int queueSize) {
        Preconditions.checkArgument(queueSize > 0, "Queue size is <= 0, must be at least 1");
        if (queueSize == 1) {
            return ONE_QUEUE;
        }
        return new RandomQueueBalancer(queueSize);
    }

    public static boolean isDeadlineQueueType(String callQueueType) {
        return callQueueType.equals(CALL_QUEUE_TYPE_DEADLINE_CONF_VALUE);
    }

    public static boolean isCodelQueueType(String callQueueType) {
        return callQueueType.equals(CALL_QUEUE_TYPE_CODEL_CONF_VALUE);
    }

    public static boolean isFifoQueueType(String callQueueType) {
        return callQueueType.equals("fifo");
    }

    public static boolean isPluggableQueueType(String callQueueType) {
        return callQueueType.equals(CALL_QUEUE_TYPE_PLUGGABLE_CONF_VALUE);
    }

    public static boolean isPluggableQueueWithFastPath(String callQueueType, Configuration conf) {
        return RpcExecutor.isPluggableQueueType(callQueueType) && conf.getBoolean(PLUGGABLE_CALL_QUEUE_WITH_FAST_PATH_ENABLED, false);
    }

    private Optional<Class<? extends BlockingQueue<CallRunner>>> getPluggableQueueClass() {
        String queueClassName = this.conf.get(PLUGGABLE_CALL_QUEUE_CLASS_NAME);
        if (queueClassName == null) {
            LOG.error("Pluggable queue class config at hbase.ipc.server.callqueue.pluggable.queue.class.name was not found");
            return Optional.empty();
        }
        try {
            Class<?> clazz = Class.forName(queueClassName);
            if (BlockingQueue.class.isAssignableFrom(clazz)) {
                return Optional.of(clazz);
            }
            LOG.error("Pluggable Queue class " + queueClassName + " does not extend BlockingQueue<CallRunner>");
            return Optional.empty();
        }
        catch (ClassNotFoundException exception) {
            LOG.error("Could not find " + queueClassName + " on the classpath to load.");
            return Optional.empty();
        }
    }

    public long getNumGeneralCallsDropped() {
        return this.numGeneralCallsDropped.longValue();
    }

    public long getNumLifoModeSwitches() {
        return this.numLifoModeSwitches.longValue();
    }

    public int getActiveHandlerCount() {
        return this.activeHandlerCount.get();
    }

    public int getActiveWriteHandlerCount() {
        return 0;
    }

    public int getActiveReadHandlerCount() {
        return 0;
    }

    public int getActiveScanHandlerCount() {
        return 0;
    }

    public int getQueueLength() {
        int length = 0;
        for (BlockingQueue<CallRunner> queue : this.queues) {
            length += queue.size();
        }
        return length;
    }

    public int getReadQueueLength() {
        return 0;
    }

    public int getScanQueueLength() {
        return 0;
    }

    public int getWriteQueueLength() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void resizeQueues(Configuration conf) {
        String configKey = "hbase.ipc.server.max.callqueue.length";
        if (this.name != null && this.name.toLowerCase(Locale.ROOT).contains("priority")) {
            configKey = "hbase.ipc.server.priority.max.callqueue.length";
        }
        this.currentQueueLimit = conf.getInt(configKey, this.currentQueueLimit);
    }

    public void onConfigurationChange(Configuration conf) {
        int codelTargetDelay = conf.getInt(CALL_QUEUE_CODEL_TARGET_DELAY, 100);
        int codelInterval = conf.getInt(CALL_QUEUE_CODEL_INTERVAL, 100);
        double codelLifoThreshold = conf.getDouble(CALL_QUEUE_CODEL_LIFO_THRESHOLD, 0.8);
        for (BlockingQueue<CallRunner> queue : this.queues) {
            if (queue instanceof AdaptiveLifoCoDelCallQueue) {
                ((AdaptiveLifoCoDelCallQueue)queue).updateTunables(codelTargetDelay, codelInterval, codelLifoThreshold);
                continue;
            }
            if (!(queue instanceof ConfigurationObserver)) continue;
            ((ConfigurationObserver)((Object)queue)).onConfigurationChange(conf);
        }
    }

    private static class CallPriorityComparator
    implements Comparator<CallRunner> {
        private static final int DEFAULT_MAX_CALL_DELAY = 5000;
        private final PriorityFunction priority;
        private final int maxDelay;

        public CallPriorityComparator(Configuration conf, PriorityFunction priority) {
            this.priority = priority;
            this.maxDelay = conf.getInt(RpcExecutor.QUEUE_MAX_CALL_DELAY_CONF_KEY, 5000);
        }

        @Override
        public int compare(CallRunner a, CallRunner b) {
            RpcCall callA = a.getRpcCall();
            RpcCall callB = b.getRpcCall();
            long deadlineA = this.priority.getDeadline(callA.getHeader(), callA.getParam());
            long deadlineB = this.priority.getDeadline(callB.getHeader(), callB.getParam());
            deadlineA = callA.getReceiveTime() + Math.min(deadlineA, (long)this.maxDelay);
            deadlineB = callB.getReceiveTime() + Math.min(deadlineB, (long)this.maxDelay);
            return Long.compare(deadlineA, deadlineB);
        }
    }

    private static class RandomQueueBalancer
    extends QueueBalancer {
        private final int queueSize;

        public RandomQueueBalancer(int queueSize) {
            this.queueSize = queueSize;
        }

        @Override
        public int getNextQueue() {
            return ThreadLocalRandom.current().nextInt(this.queueSize);
        }
    }

    public static abstract class QueueBalancer {
        public abstract int getNextQueue();
    }

    protected class Handler
    extends Thread {
        final BlockingQueue<CallRunner> q;
        final double handlerFailureThreshhold;
        final AtomicInteger activeHandlerCount;

        Handler(String name, double handlerFailureThreshhold, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount) {
            super(name);
            this.setDaemon(true);
            this.q = q;
            this.handlerFailureThreshhold = handlerFailureThreshhold;
            this.activeHandlerCount = activeHandlerCount;
        }

        protected CallRunner getCallRunner() throws InterruptedException {
            return this.q.take();
        }

        @Override
        public void run() {
            boolean interrupted = false;
            try {
                while (RpcExecutor.this.running) {
                    try {
                        this.run(this.getCallRunner());
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn(e.toString(), (Throwable)e);
                throw e;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void run(CallRunner cr) {
            MonitoredRPCHandler status = RpcServer.getStatus();
            cr.setStatus(status);
            try {
                this.activeHandlerCount.incrementAndGet();
                cr.run();
                return;
            }
            catch (Throwable e) {
                if (!(e instanceof Error)) {
                    LOG.warn("Handler  exception " + StringUtils.stringifyException((Throwable)e));
                    return;
                }
                int failedCount = RpcExecutor.this.failedHandlerCount.incrementAndGet();
                if (this.handlerFailureThreshhold >= 0.0 && (double)failedCount > (double)RpcExecutor.this.handlerCount * this.handlerFailureThreshhold) {
                    String message = "Number of failed RpcServer handler runs exceeded threshhold " + this.handlerFailureThreshhold + "; reason: " + StringUtils.stringifyException((Throwable)e);
                    if (RpcExecutor.this.abortable != null) {
                        RpcExecutor.this.abortable.abort(message, e);
                        return;
                    }
                    LOG.error("Error but can't abort because abortable is null: " + StringUtils.stringifyException((Throwable)e));
                    throw e;
                }
                LOG.warn("Handler errors " + StringUtils.stringifyException((Throwable)e));
                return;
            }
            finally {
                this.activeHandlerCount.decrementAndGet();
            }
        }
    }
}

