/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LoadBalancerProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LoadBalancerTracker
extends ZKNodeTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LoadBalancerTracker.class);

    public LoadBalancerTracker(ZKWatcher watcher, Abortable abortable) {
        super(watcher, watcher.getZNodePaths().balancerZNode, abortable);
    }

    public boolean isBalancerOn() {
        byte[] upData = super.getData(false);
        try {
            return upData == null || this.parseFrom(upData).getBalancerOn();
        }
        catch (DeserializationException dex) {
            LOG.error("ZK state for LoadBalancer could not be parsed {}", (Object)Bytes.toStringBinary(upData));
            return false;
        }
    }

    public void setBalancerOn(boolean balancerOn) throws KeeperException {
        byte[] upData = this.toByteArray(balancerOn);
        try {
            ZKUtil.setData(this.watcher, this.watcher.getZNodePaths().balancerZNode, upData);
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createAndWatch(this.watcher, this.watcher.getZNodePaths().balancerZNode, upData);
        }
        super.nodeDataChanged(this.watcher.getZNodePaths().balancerZNode);
    }

    private byte[] toByteArray(boolean isBalancerOn) {
        LoadBalancerProtos.LoadBalancerState.Builder builder = LoadBalancerProtos.LoadBalancerState.newBuilder();
        builder.setBalancerOn(isBalancerOn);
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    private LoadBalancerProtos.LoadBalancerState parseFrom(byte[] pbBytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(pbBytes);
        LoadBalancerProtos.LoadBalancerState.Builder builder = LoadBalancerProtos.LoadBalancerState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom(builder, pbBytes, magicLen, pbBytes.length - magicLen);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return builder.build();
    }
}

