# PIP-325: Support reading from transaction buffer for pending transaction

# Background knowledge

In the current implementation of Pulsar Transaction, Topics ensure that consumers do not read messages belonging
to uncommitted transactions through the Transaction Buffer. Within the Transaction Buffer, a Position (`maxReadPosition`)
is maintained, as well as a set of aborted transactions (`aborts`). The `maxReadPosition` controls the maximum message
position that the broker can read, and it is adjusted to the position just before the first message of the first ongoing
transaction when a transaction is committed or aborted. Before distributing messages to consumers, the broker filters out
messages that belong to already aborted transactions using the `aborts` set.

# Motivation
If we have a stuck transaction, then the transactions after this one cannot be consumed by the consumer
even if they have been committed. The consumer will be stuck until the stuck transaction is aborted due to timeout,
and then it will continue to consume messages. Therefore, we need to add a command to allow cluster administrators
to proactively abort transaction.

# Goals

## In Scope

Introduce a new API for aborting transactions, allowing administrators to proactively abort transaction.

## Out of Scope

None.


# High Level Design

Introduce a new API for aborting transactions, allowing administrators to proactively abort transaction.

# Detailed Design

## Design & Implementation Details

Introduce a new API for aborting transactions, allowing administrators to proactively abort transaction.

## Public-facing Changes

### Public API
Add a new API to abort transaction:
```
    /**
     * Abort a transaction.
     *
     * @param txnID the txnId
     */
    void abortTransaction(TxnID txnID) throws PulsarAdminException;

    /**
     * Asynchronously Abort a transaction.
     *
     * @param txnID the txnId
     */
    CompletableFuture<Void> abortTransactionAsync(TxnID txnID);
```
```
admin.transactions().abortTransaction(txnID);
```

### Binary protocol

### Configuration

### CLI
Add a command to abort transaction:
```
pulsar-admin transactions abort-transaction --most-sig-bits 1 --least-sig-bits 2
```
### Metrics
None.

# Monitoring
None.

# Security Considerations
The transaction owner and super user can access the admin API to abort the transaction.

# Backward & Forward Compatibility

## Revert

## Upgrade

# Alternatives

# General Notes

# Links

<!--
Updated afterwards
-->
* Mailing List discussion thread: https://lists.apache.org/thread/ssgngyrlgx36zvygvsd5b2dm5q6krn0f
* Mailing List voting thread: https://lists.apache.org/thread/kp9w4d8drngomx1mdof0203ybgfmvtty
