/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.Writer;

public class FastWriter
extends Writer {
    private static final int BUFSIZE = 8192;
    protected final Writer sink;
    protected char[] buf;
    protected int pos;

    public FastWriter(Writer w) {
        this(w, new char[8192], 0);
    }

    public FastWriter(Writer sink, char[] tempBuffer, int start) {
        this.sink = sink;
        this.buf = tempBuffer;
        this.pos = start;
    }

    public static FastWriter wrap(Writer sink) {
        return sink instanceof FastWriter ? (FastWriter)sink : new FastWriter(sink);
    }

    @Override
    public void write(int c) throws IOException {
        this.write((char)c);
    }

    public void write(char c) throws IOException {
        if (this.pos >= this.buf.length) {
            this.flush(this.buf, 0, this.pos);
            this.pos = 0;
        }
        this.buf[this.pos++] = c;
    }

    @Override
    public FastWriter append(char c) throws IOException {
        if (this.pos >= this.buf.length) {
            this.flush(this.buf, 0, this.pos);
            this.pos = 0;
        }
        this.buf[this.pos++] = c;
        return this;
    }

    @Override
    public void write(char[] arr, int off, int len) throws IOException {
        while (true) {
            int space;
            if (len <= (space = this.buf.length - this.pos)) {
                System.arraycopy(arr, off, this.buf, this.pos, len);
                this.pos += len;
                return;
            }
            if (len > this.buf.length) {
                if (this.pos > 0) {
                    this.flush(this.buf, 0, this.pos);
                    this.pos = 0;
                }
                this.flush(arr, off, len);
                return;
            }
            System.arraycopy(arr, off, this.buf, this.pos, space);
            this.flush(this.buf, 0, this.buf.length);
            this.pos = 0;
            off += space;
            len -= space;
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        while (true) {
            int space;
            if (len <= (space = this.buf.length - this.pos)) {
                str.getChars(off, off + len, this.buf, this.pos);
                this.pos += len;
                return;
            }
            if (len > this.buf.length) {
                if (this.pos > 0) {
                    this.flush(this.buf, 0, this.pos);
                    this.pos = 0;
                }
                this.flush(str, off, len);
                return;
            }
            str.getChars(off, off + space, this.buf, this.pos);
            this.flush(this.buf, 0, this.buf.length);
            this.pos = 0;
            off += space;
            len -= space;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(this.buf, 0, this.pos);
        this.pos = 0;
        if (this.sink != null) {
            this.sink.flush();
        }
    }

    public void flush(char[] buf, int offset, int len) throws IOException {
        this.sink.write(buf, offset, len);
    }

    public void flush(String str, int offset, int len) throws IOException {
        this.sink.write(str, offset, len);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.sink != null) {
            this.sink.close();
        }
    }

    public void flushBuffer() throws IOException {
        this.flush(this.buf, 0, this.pos);
        this.pos = 0;
    }
}

