/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.presto.client;

import java.io.Closeable;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrestoClient
extends BaseClient
implements Closeable {
    public static final String PRESTO_USER_NAME_PROP = "user";
    public static final String PRESTO_PASSWORD_PROP = "password";
    private static final Logger LOG = LoggerFactory.getLogger(PrestoClient.class);
    private static final String ERR_MSG = "You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    private Connection con;

    public PrestoClient(String serviceName) throws Exception {
        super(serviceName, null);
        this.init();
    }

    public PrestoClient(String serviceName, Map<String, String> properties) throws Exception {
        super(serviceName, properties);
        this.init();
    }

    private void init() throws Exception {
        Subject.doAs(this.getLoginSubject(), new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PrestoClient.this.initConnection();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnection() {
        Properties prop = this.getConfigHolder().getRangerSection();
        String driverClassName = prop.getProperty("jdbc.driverClassName");
        String url = prop.getProperty("jdbc.url");
        Properties prestoProperties = new Properties();
        String decryptedPwd = null;
        try {
            decryptedPwd = PasswordUtils.decryptPassword((String)this.getConfigHolder().getPassword());
        }
        catch (Exception ex) {
            LOG.info("Password decryption failed");
            decryptedPwd = null;
        }
        finally {
            if (decryptedPwd == null) {
                decryptedPwd = prop.getProperty(PRESTO_PASSWORD_PROP);
            }
        }
        prestoProperties.put(PRESTO_USER_NAME_PROP, prop.getProperty("username"));
        if (prop.getProperty(PRESTO_PASSWORD_PROP) != null) {
            prestoProperties.put(PRESTO_PASSWORD_PROP, prop.getProperty(PRESTO_PASSWORD_PROP));
        }
        if (driverClassName != null) {
            try {
                Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                DriverManager.registerDriver(driver);
            }
            catch (SQLException e) {
                String msgDesc = "initConnection: Caught SQLException while registering the Presto driver.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (IllegalAccessException ilae) {
                String msgDesc = "initConnection: Class or its nullary constructor might not accessible.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ilae);
                hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)ilae), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (InstantiationException ie) {
                String msgDesc = "initConnection: Class may not have its nullary constructor or may be the instantiation fails for some other reason.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ie);
                hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)ie), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (ExceptionInInitializerError eie) {
                String msgDesc = "initConnection: Got ExceptionInInitializerError, The initialization provoked by this method fails.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)eie);
                hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)eie), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (SecurityException se) {
                String msgDesc = "initConnection: unable to initiate connection to Presto instance, The caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of s.checkPackageAccess() denies access to the package of this class.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
                hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)se), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (Throwable t) {
                String msgDesc = "initConnection: Unable to connect to Presto instance, please provide valid value of field : {jdbc.driverClassName}.";
                HadoopException hdpException = new HadoopException(msgDesc, t);
                hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)t), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
        }
        try {
            this.con = DriverManager.getConnection(url, prestoProperties);
        }
        catch (SQLException e) {
            String msgDesc = "Unable to connect to Presto instance.";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
            hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
            throw hdpException;
        }
        catch (SecurityException se) {
            String msgDesc = "Unable to connect to Presto instance.";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
            hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)se), msgDesc + ERR_MSG, null, null);
            throw hdpException;
        }
        catch (Throwable t) {
            String msgDesc = "initConnection: Unable to connect to Presto instance, ";
            HadoopException hdpException = new HadoopException(msgDesc, t);
            hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)t), msgDesc + ERR_MSG, null, null);
            throw hdpException;
        }
    }

    /*
     * Loose catch block
     */
    private List<String> getCatalogs(String needle, List<String> catalogs) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con != null) {
            Statement stat = null;
            ResultSet rs = null;
            String sql = "SHOW CATALOGS";
            try {
                if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                    sql = sql + " LIKE '" + PrestoClient.escapeSql(needle) + "%'";
                }
                stat = this.con.createStatement();
                rs = stat.executeQuery(sql);
                while (rs.next()) {
                    String catalogName = rs.getString(1);
                    if (catalogs != null && catalogs.contains(catalogName)) continue;
                    ret.add(catalogName);
                }
                this.close(rs);
                this.close(stat);
            }
            catch (SQLTimeoutException sqlt) {
                String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
                this.close(rs);
                this.close(stat);
            }
            catch (SQLException se) {
                String msg = "Unable to execute SQL [" + sql + "]. ";
                HadoopException he = new HadoopException(msg, (Throwable)se);
                he.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)se), msg + ERR_MSG, null, null);
                throw he;
                {
                    catch (Throwable throwable) {
                        this.close(rs);
                        this.close(stat);
                        throw throwable;
                    }
                }
            }
        }
        return ret;
    }

    public List<String> getCatalogList(String needle, List<String> catalogs) throws HadoopException {
        final String ndl = needle;
        final List<String> catList = catalogs;
        List<String> dbs = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = PrestoClient.this.getCatalogs(ndl, catList);
                }
                catch (HadoopException he) {
                    LOG.error("<== PrestoClient.getCatalogList() :Unable to get the Database List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return dbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getSchemas(String needle, List<String> catalogs, List<String> schemas) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con == null) return ret;
        Statement stat = null;
        ResultSet rs = null;
        String sql = null;
        try {
            if (catalogs == null || catalogs.isEmpty()) return ret;
            for (String catalog : catalogs) {
                sql = "SHOW SCHEMAS FROM \"" + PrestoClient.escapeSql(catalog) + "\"";
                try {
                    if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                        sql = sql + " LIKE '" + PrestoClient.escapeSql(needle) + "%'";
                    }
                    stat = this.con.createStatement();
                    rs = stat.executeQuery(sql);
                    while (rs.next()) {
                        String schema = rs.getString(1);
                        if (schemas != null && schemas.contains(schema)) continue;
                        ret.add(schema);
                    }
                    this.close(rs);
                    this.close(stat);
                    rs = null;
                    stat = null;
                }
                catch (Throwable throwable) {
                    this.close(rs);
                    this.close(stat);
                    rs = null;
                    stat = null;
                    throw throwable;
                    return ret;
                }
            }
        }
        catch (SQLTimeoutException sqlt) {
            String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
            hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== PrestoClient.getSchemas() Error : ", (Throwable)sqlt);
            throw hdpException;
        }
        catch (SQLException sqle) {
            String msgDesc = "Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
            hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== PrestoClient.getSchemas() Error : ", (Throwable)sqle);
            throw hdpException;
        }
    }

    public List<String> getSchemaList(String needle, List<String> catalogs, List<String> schemas) throws HadoopException {
        final String ndl = needle;
        final List<String> cats = catalogs;
        final List<String> shms = schemas;
        List<String> schemaList = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = PrestoClient.this.getSchemas(ndl, cats, shms);
                }
                catch (HadoopException he) {
                    LOG.error("<== PrestoClient.getSchemaList() :Unable to get the Schema List", (Throwable)he);
                }
                return ret;
            }
        });
        return schemaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getTables(String needle, List<String> catalogs, List<String> schemas, List<String> tables) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con == null) return ret;
        Statement stat = null;
        ResultSet rs = null;
        String sql = null;
        if (catalogs == null) return ret;
        if (catalogs.isEmpty() || schemas == null || schemas.isEmpty()) return ret;
        try {
            for (String catalog : catalogs) {
                for (String schema : schemas) {
                    sql = "SHOW tables FROM \"" + PrestoClient.escapeSql(catalog) + "\".\"" + PrestoClient.escapeSql(schema) + "\"";
                    try {
                        if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                            sql = sql + " LIKE '" + PrestoClient.escapeSql(needle) + "%'";
                        }
                        stat = this.con.createStatement();
                        rs = stat.executeQuery(sql);
                        while (rs.next()) {
                            String table = rs.getString(1);
                            if (tables != null && tables.contains(table)) continue;
                            ret.add(table);
                        }
                        this.close(rs);
                        this.close(stat);
                        rs = null;
                        stat = null;
                    }
                    catch (Throwable throwable) {
                        this.close(rs);
                        this.close(stat);
                        rs = null;
                        stat = null;
                        throw throwable;
                    }
                }
                continue;
                return ret;
            }
        }
        catch (SQLTimeoutException sqlt) {
            String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
            hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== PrestoClient.getTables() Error : ", (Throwable)sqlt);
            throw hdpException;
        }
        catch (SQLException sqle) {
            String msgDesc = "Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
            hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== PrestoClient.getTables() Error : ", (Throwable)sqle);
            throw hdpException;
        }
    }

    public List<String> getTableList(String needle, List<String> catalogs, List<String> schemas, List<String> tables) throws HadoopException {
        final String ndl = needle;
        final List<String> cats = catalogs;
        final List<String> shms = schemas;
        final List<String> tbls = tables;
        List<String> tableList = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = PrestoClient.this.getTables(ndl, cats, shms, tbls);
                }
                catch (HadoopException he) {
                    LOG.error("<== PrestoClient.getTableList() :Unable to get the Column List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getColumns(String needle, List<String> catalogs, List<String> schemas, List<String> tables, List<String> columns) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con == null) return ret;
        String regex = null;
        ResultSet rs = null;
        String sql = null;
        Statement stat = null;
        if (needle != null && !needle.isEmpty()) {
            regex = needle;
        }
        if (catalogs == null || catalogs.isEmpty() || schemas == null || schemas.isEmpty() || tables == null || tables.isEmpty()) return ret;
        try {
            for (String catalog : catalogs) {
                for (String schema : schemas) {
                    for (String table : tables) {
                        sql = "SHOW COLUMNS FROM \"" + PrestoClient.escapeSql(catalog) + "\".\"" + PrestoClient.escapeSql(schema) + "\".\"" + PrestoClient.escapeSql(table) + "\"";
                        try {
                            stat = this.con.createStatement();
                            rs = stat.executeQuery(sql);
                            while (rs.next()) {
                                String column = rs.getString(1);
                                if (columns != null && columns.contains(column)) continue;
                                if (regex == null) {
                                    ret.add(column);
                                    continue;
                                }
                                if (!FilenameUtils.wildcardMatch((String)column, (String)regex)) continue;
                                ret.add(column);
                            }
                            this.close(rs);
                            this.close(stat);
                            stat = null;
                            rs = null;
                        }
                        catch (Throwable throwable) {
                            this.close(rs);
                            this.close(stat);
                            stat = null;
                            rs = null;
                            throw throwable;
                        }
                    }
                }
                continue;
                return ret;
            }
        }
        catch (SQLTimeoutException sqlt) {
            String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
            hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== PrestoClient.getColumns() Error : ", (Throwable)sqlt);
            throw hdpException;
        }
        catch (SQLException sqle) {
            String msgDesc = "Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
            hdpException.generateResponseDataMap(false, PrestoClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== PrestoClient.getColumns() Error : ", (Throwable)sqle);
            throw hdpException;
        }
    }

    public List<String> getColumnList(String needle, List<String> catalogs, List<String> schemas, List<String> tables, List<String> columns) throws HadoopException {
        final String ndl = needle;
        final List<String> cats = catalogs;
        final List<String> shms = schemas;
        final List<String> tbls = tables;
        final List<String> cols = columns;
        List<String> columnList = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = PrestoClient.this.getColumns(ndl, cats, shms, tbls, cols);
                }
                catch (HadoopException he) {
                    LOG.error("<== PrestoClient.getColumnList() :Unable to get the Column List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return columnList;
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> connectionProperties) throws Exception {
        PrestoClient client = null;
        HashMap<String, Object> resp = new HashMap<String, Object>();
        boolean status = false;
        List<String> testResult = null;
        try {
            client = new PrestoClient(serviceName, connectionProperties);
            if (client != null && (testResult = client.getCatalogList("*", null)) != null && testResult.size() != 0) {
                status = true;
            }
            if (status) {
                String msg = "Connection test successful";
                PrestoClient.generateResponseDataMap((boolean)status, (String)msg, (String)msg, null, null, resp);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return resp;
    }

    @Override
    public void close() {
        Subject.doAs(this.getLoginSubject(), new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PrestoClient.this.close(PrestoClient.this.con);
                return null;
            }
        });
    }

    private void close(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close Presto SQL connection", (Throwable)e);
        }
    }

    public void close(Statement stat) {
        try {
            if (stat != null) {
                stat.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close SQL statement", (Throwable)e);
        }
    }

    public void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close ResultSet", (Throwable)e);
        }
    }

    private static String escapeSql(String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.replace((String)str, (String)"'", (String)"''");
    }
}

