/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.om.helpers.OmPartInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OmMultipartUploadListParts {
    private ReplicationConfig replicationConfig;
    private int nextPartNumberMarker;
    private boolean truncated;
    private final List<OmPartInfo> partInfoList = new ArrayList<OmPartInfo>();

    public OmMultipartUploadListParts(ReplicationConfig replicationConfig, int nextMarker, boolean truncate) {
        this.replicationConfig = replicationConfig;
        this.nextPartNumberMarker = nextMarker;
        this.truncated = truncate;
    }

    public void addPart(OmPartInfo partInfo) {
        this.partInfoList.add(partInfo);
    }

    public int getNextPartNumberMarker() {
        return this.nextPartNumberMarker;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public List<OmPartInfo> getPartInfoList() {
        return this.partInfoList;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public void addPartList(List<OmPartInfo> partInfos) {
        this.partInfoList.addAll(partInfos);
    }

    public void addProtoPartList(List<OzoneManagerProtocolProtos.PartInfo> partInfos) {
        partInfos.forEach(partInfo -> this.partInfoList.add(new OmPartInfo(partInfo.getPartNumber(), partInfo.getPartName(), partInfo.getModificationTime(), partInfo.getSize(), partInfo.getETag())));
    }
}

