/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.impexp;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.model.AtlasBaseModelObject;
import org.apache.atlas.type.AtlasType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasServer
extends AtlasBaseModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY_REPLICATION_DETAILS = "REPL_DETAILS";
    private String name;
    private String fullName;
    private String displayName;
    private Map<String, String> additionalInfo = new HashMap<String, String>();
    private List<String> urls = new ArrayList<String>();

    public AtlasServer() {
    }

    public AtlasServer(String name, String fullName) {
        this(name, name, fullName);
    }

    public AtlasServer(String name, String displayName, String fullName) {
        this.name = name;
        this.displayName = displayName;
        this.fullName = fullName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public String getAdditionalInfo(String key) {
        return this.additionalInfo.get(key);
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public void setAdditionalInfo(String key, String value) {
        if (this.additionalInfo == null) {
            this.additionalInfo = new HashMap<String, String>();
        }
        this.additionalInfo.put(key, value);
    }

    public void setAdditionalInfoRepl(String guid, long modifiedTimestamp) {
        Map<String, Object> replicationDetailsMap = null;
        if (this.additionalInfo != null && this.additionalInfo.containsKey(KEY_REPLICATION_DETAILS)) {
            replicationDetailsMap = AtlasType.fromJson(this.getAdditionalInfo().get(KEY_REPLICATION_DETAILS), Map.class);
        }
        if (replicationDetailsMap == null) {
            replicationDetailsMap = new HashMap<String, Object>();
        }
        if (modifiedTimestamp == 0L) {
            replicationDetailsMap.remove(guid);
        } else {
            replicationDetailsMap.put(guid, modifiedTimestamp);
        }
        this.updateReplicationMap(replicationDetailsMap);
    }

    public Object getAdditionalInfoRepl(String guid) {
        if (this.additionalInfo == null || !this.additionalInfo.containsKey(KEY_REPLICATION_DETAILS)) {
            return null;
        }
        String key = guid;
        String mapJson = this.additionalInfo.get(KEY_REPLICATION_DETAILS);
        Map replicationDetailsMap = AtlasType.fromJson(mapJson, Map.class);
        if (!replicationDetailsMap.containsKey(key)) {
            return null;
        }
        return replicationDetailsMap.get(key);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append(", name=").append(this.name);
        sb.append(", fullName=").append(this.fullName);
        sb.append(", displayName=").append(this.displayName);
        sb.append(", additionalInfo=").append(this.additionalInfo);
        sb.append(", urls=").append(this.urls);
        return sb;
    }

    private void updateReplicationMap(Map<String, Object> replicationDetailsMap) {
        String json = AtlasType.toJson(replicationDetailsMap);
        this.setAdditionalInfo(KEY_REPLICATION_DETAILS, json);
    }
}

