/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.ESLogMessage;

public class DeprecatedMessage
extends ESLogMessage {
    public static final String ELASTIC_ORIGIN_FIELD_NAME = "elasticsearch.elastic_product_origin";
    public static final String X_OPAQUE_ID_FIELD_NAME = "x-opaque-id";
    public static final String KEY_FIELD_NAME = "key";

    public DeprecatedMessage(DeprecationCategory category, String key, String xOpaqueId, String productOrigin, String messagePattern, Object ... args) {
        super(DeprecatedMessage.fieldMap(category, key, xOpaqueId, productOrigin), messagePattern, args);
    }

    private static Map<String, Object> fieldMap(DeprecationCategory category, String key, String xOpaqueId, String productOrigin) {
        MapBuilder<String, String> builder = MapBuilder.newMapBuilder();
        Objects.requireNonNull(category, "category cannot be null");
        builder.put("category", category.name().toLowerCase(Locale.ROOT));
        if (!Strings.isNullOrEmpty(key)) {
            builder.put(KEY_FIELD_NAME, key);
        }
        if (!Strings.isNullOrEmpty(xOpaqueId)) {
            builder.put(X_OPAQUE_ID_FIELD_NAME, xOpaqueId);
        }
        if (!Strings.isNullOrEmpty(productOrigin)) {
            builder.put(ELASTIC_ORIGIN_FIELD_NAME, productOrigin);
        }
        return builder.immutableMap();
    }
}

