/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AbstractRpcBasedConnectionRegistry;
import org.apache.hadoop.hbase.client.MasterRegistry;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class RpcConnectionRegistry
extends AbstractRpcBasedConnectionRegistry {
    public static final String HEDGED_REQS_FANOUT_KEY = "hbase.client.bootstrap.hedged.fanout";
    public static final String INITIAL_REFRESH_DELAY_SECS = "hbase.client.bootstrap.initial_refresh_delay_secs";
    public static final String PERIODIC_REFRESH_INTERVAL_SECS = "hbase.client.bootstrap.refresh_interval_secs";
    public static final String MIN_SECS_BETWEEN_REFRESHES = "hbase.client.bootstrap.min_secs_between_refreshes";
    public static final String BOOTSTRAP_NODES = "hbase.client.bootstrap.servers";
    private static final char ADDRS_CONF_SEPARATOR = ',';
    private final String connectionString;

    RpcConnectionRegistry(Configuration conf, User user) throws IOException {
        super(conf, user, HEDGED_REQS_FANOUT_KEY, INITIAL_REFRESH_DELAY_SECS, PERIODIC_REFRESH_INTERVAL_SECS, MIN_SECS_BETWEEN_REFRESHES);
        this.connectionString = this.buildConnectionString(conf);
    }

    private String buildConnectionString(Configuration conf) throws UnknownHostException {
        String configuredBootstrapNodes = conf.get(BOOTSTRAP_NODES);
        if (StringUtils.isBlank((CharSequence)configuredBootstrapNodes)) {
            return MasterRegistry.getConnectionString(conf);
        }
        return Splitter.on((char)',').trimResults().splitToStream((CharSequence)configuredBootstrapNodes).collect(Collectors.joining(String.valueOf(',')));
    }

    @Override
    protected Set<ServerName> getBootstrapNodes(Configuration conf) throws IOException {
        String configuredBootstrapNodes = conf.get(BOOTSTRAP_NODES);
        if (!StringUtils.isBlank((CharSequence)configuredBootstrapNodes)) {
            return Splitter.on((char)',').trimResults().splitToStream((CharSequence)configuredBootstrapNodes).map(addr -> ServerName.valueOf((String)addr, (long)-1L)).collect(Collectors.toSet());
        }
        return MasterRegistry.parseMasterAddrs(conf);
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    private static Set<ServerName> transformServerNames(RegistryProtos.GetBootstrapNodesResponse resp) {
        return resp.getServerNameList().stream().map(ProtobufUtil::toServerName).collect(Collectors.toSet());
    }

    private CompletableFuture<Set<ServerName>> getBootstrapNodes() {
        return this.call((c, s, d) -> s.getBootstrapNodes((RpcController)c, RegistryProtos.GetBootstrapNodesRequest.getDefaultInstance(), d), r -> r.getServerNameCount() != 0, "getBootstrapNodes()").thenApply(RpcConnectionRegistry::transformServerNames);
    }

    @Override
    protected CompletableFuture<Set<ServerName>> fetchEndpoints() {
        return this.getBootstrapNodes();
    }
}

