/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.StringUtils;

public class ConfigurationManager {
    private final RaftPeerId id;
    private final RaftConfigurationImpl initialConf;
    private final NavigableMap<Long, RaftConfigurationImpl> configurations = new TreeMap<Long, RaftConfigurationImpl>();
    private RaftConfigurationImpl currentConf;
    private RaftPeer currentPeer;

    ConfigurationManager(RaftPeerId id, RaftConfigurationImpl initialConf) {
        this.id = id;
        this.initialConf = initialConf;
        this.setCurrentConf(initialConf);
    }

    private void setCurrentConf(RaftConfigurationImpl currentConf) {
        this.currentConf = currentConf;
        RaftPeer peer = currentConf.getPeer(this.id, RaftProtos.RaftPeerRole.FOLLOWER, RaftProtos.RaftPeerRole.LISTENER);
        if (peer != null) {
            this.currentPeer = peer;
        }
    }

    synchronized void addConfiguration(RaftConfiguration conf) {
        long logIndex = conf.getLogEntryIndex();
        RaftConfiguration found = (RaftConfiguration)this.configurations.get(logIndex);
        if (found != null) {
            Preconditions.assertTrue(found.equals(conf));
            return;
        }
        this.addRaftConfigurationImpl(logIndex, (RaftConfigurationImpl)conf);
    }

    private void addRaftConfigurationImpl(long logIndex, RaftConfigurationImpl conf) {
        this.configurations.put(logIndex, conf);
        if (logIndex == this.configurations.lastEntry().getKey()) {
            this.setCurrentConf(conf);
        }
    }

    synchronized RaftConfigurationImpl getCurrent() {
        return this.currentConf;
    }

    synchronized RaftPeer getCurrentPeer() {
        return this.currentPeer;
    }

    synchronized void removeConfigurations(long index) {
        SortedMap<Long, RaftConfigurationImpl> tail = this.configurations.tailMap(index);
        if (tail.isEmpty()) {
            return;
        }
        tail.clear();
        this.setCurrentConf(this.configurations.isEmpty() ? this.initialConf : this.configurations.lastEntry().getValue());
    }

    synchronized int numOfConf() {
        return 1 + this.configurations.size();
    }

    public synchronized String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ", init=" + this.initialConf + ", confs=" + StringUtils.map2String(this.configurations);
    }
}

