/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.primitives.Pullable;

public interface MutableS2Point
extends Comparable<MutableS2Point> {
    public double getX();

    public double getY();

    public double getZ();

    public void set(S2Point var1);

    public void set(double var1, double var3, double var5);

    default public boolean isEqualTo(S2Point other) {
        return this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ();
    }

    default public boolean isEqualTo(MutableS2Point other) {
        return this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ();
    }

    @Override
    default public int compareTo(MutableS2Point other) {
        if (this.getX() < other.getX()) {
            return -1;
        }
        if (other.getX() < this.getX()) {
            return 1;
        }
        if (this.getY() < other.getY()) {
            return -1;
        }
        if (other.getY() < this.getY()) {
            return 1;
        }
        if (this.getZ() < other.getZ()) {
            return -1;
        }
        if (other.getZ() < this.getZ()) {
            return 1;
        }
        return 0;
    }

    public static class MutableS2PointList
    implements Pullable.PullList<MutableS2Point> {
        static final int DEFAULT_CAPACITY = 16;
        private double[] coordinates;
        private int size;
        private int capacity;

        public MutableS2PointList() {
            this(new double[48], 0);
        }

        public MutableS2PointList(int size) {
            this(new double[size * 3], size);
        }

        public MutableS2PointList(MutableS2PointList other) {
            this(Arrays.copyOf(other.coordinates, other.size() * 3), other.size());
        }

        private MutableS2PointList(double[] coordinates, int size) {
            assert (coordinates.length % 3 == 0);
            assert (coordinates.length >= size * 3);
            this.coordinates = coordinates;
            this.size = size;
            this.capacity = coordinates.length / 3;
        }

        public static MutableS2PointList ofCapacity(int capacity) {
            MutableS2PointList list = new MutableS2PointList();
            list.ensureCapacity(capacity);
            return list;
        }

        public static MutableS2PointList pair() {
            return new MutableS2PointList(2);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean ensureCapacity(int requiredCapacity) {
            if (requiredCapacity <= this.capacity) {
                return false;
            }
            this.capacity = Integer.highestOneBit(requiredCapacity);
            this.capacity = this.capacity == requiredCapacity ? this.capacity : this.capacity << 1;
            this.coordinates = Arrays.copyOf(this.coordinates, this.capacity * 3);
            return true;
        }

        @Override
        public void enlarge(int newSize) {
            this.ensureCapacity(newSize);
            if (newSize > this.size) {
                this.size = newSize;
            }
        }

        @Override
        public void truncate(int newSize) {
            if (newSize < this.size) {
                this.size = newSize;
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        public int capacity() {
            return this.capacity;
        }

        @Override
        public MutableS2Point newElement() {
            return new MutableS2PointImpl();
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        public void sort() {
            this.sort(Comparator.naturalOrder());
        }

        private void rangeCheck(int index) {
            if (index >= this.size || index < 0) {
                throw new IndexOutOfBoundsException("index " + index + " out of bounds for size " + this.size);
            }
        }

        public S2Point getImmutable(int i) {
            this.rangeCheck(i);
            return new S2Point(this.coordinates[i * 3], this.coordinates[i * 3 + 1], this.coordinates[i * 3 + 2]);
        }

        public boolean isEqualTo(int index, S2Point other) {
            this.rangeCheck(index);
            int i = index * 3;
            return this.coordinates[i + 0] == other.getX() && this.coordinates[i + 1] == other.getY() && this.coordinates[i + 2] == other.getZ();
        }

        public boolean isEqualTo(int index, MutableS2Point other) {
            this.rangeCheck(index);
            int i = index * 3;
            return this.coordinates[i + 0] == other.getX() && this.coordinates[i + 1] == other.getY() && this.coordinates[i + 2] == other.getZ();
        }

        public boolean isEqualTo(int aIndex, int bIndex) {
            int ia = aIndex * 3;
            int ib = bIndex * 3;
            return this.coordinates[ia + 0] == this.coordinates[ib + 0] && this.coordinates[ia + 1] == this.coordinates[ib + 1] && this.coordinates[ia + 2] == this.coordinates[ib + 2];
        }

        @Override
        public void get(int index, MutableS2Point value) {
            this.rangeCheck(index);
            int i = index * 3;
            value.set(this.coordinates[i + 0], this.coordinates[i + 1], this.coordinates[i + 2]);
        }

        public MutableS2Point get(final int index) {
            this.rangeCheck(index);
            return new MutableS2Point(){
                private final int i;
                {
                    this.i = index * 3;
                }

                @Override
                public double getX() {
                    return coordinates[this.i];
                }

                @Override
                public double getY() {
                    return coordinates[this.i + 1];
                }

                @Override
                public double getZ() {
                    return coordinates[this.i + 2];
                }

                @Override
                public void set(S2Point other) {
                    coordinates[this.i + 0] = other.getX();
                    coordinates[this.i + 1] = other.getY();
                    coordinates[this.i + 2] = other.getZ();
                }

                @Override
                public void set(double x, double y, double z) {
                    coordinates[this.i + 0] = x;
                    coordinates[this.i + 1] = y;
                    coordinates[this.i + 2] = z;
                }

                public String toString() {
                    return "(" + coordinates[this.i + 0] + ", " + coordinates[this.i + 1] + ", " + coordinates[this.i + 2] + ")";
                }
            };
        }

        @Override
        public void set(int index, MutableS2Point point) {
            this.rangeCheck(index);
            int i = index * 3;
            this.coordinates[i + 0] = point.getX();
            this.coordinates[i + 1] = point.getY();
            this.coordinates[i + 2] = point.getZ();
        }

        @Override
        public void set(int index, S2Point point) {
            this.rangeCheck(index);
            int i = index * 3;
            this.coordinates[i + 0] = point.getX();
            this.coordinates[i + 1] = point.getY();
            this.coordinates[i + 2] = point.getZ();
        }

        @Override
        public void copy(int indexA, int indexB) {
            int ia = indexA * 3;
            int ib = indexB * 3;
            this.coordinates[ib + 0] = this.coordinates[ia + 0];
            this.coordinates[ib + 1] = this.coordinates[ia + 1];
            this.coordinates[ib + 2] = this.coordinates[ia + 2];
        }

        @Override
        public void add(MutableS2Point value) {
            this.add(value.getX(), value.getY(), value.getZ());
        }

        @Override
        public void add(S2Point value) {
            this.add(value.x, value.y, value.z);
        }

        public void add(double x, double y, double z) {
            this.ensureCapacity(this.size + 1);
            int i = this.size * 3;
            this.coordinates[i + 0] = x;
            this.coordinates[i + 1] = y;
            this.coordinates[i + 2] = z;
            ++this.size;
        }

        public List<S2Point> asPointList() {
            return new AbstractList<S2Point>(){

                @Override
                public S2Point get(int index) {
                    return this.getImmutable(index);
                }

                @Override
                public S2Point set(int index, S2Point value) {
                    S2Point returnValue = this.get(index);
                    this.set(index, value);
                    return returnValue;
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
        }

        public boolean forEach(PointVisitor action) {
            for (int index = 0; index < this.size; ++index) {
                int i = index * 3;
                if (action.accept(this.coordinates[i + 0], this.coordinates[i + 1], this.coordinates[i + 2])) continue;
                return false;
            }
            return true;
        }

        public boolean forEach(PointOffsetVisitor action) {
            for (int index = 0; index < this.size; ++index) {
                int i = index * 3;
                if (action.accept(index, this.coordinates[i + 0], this.coordinates[i + 1], this.coordinates[i + 2])) continue;
                return false;
            }
            return true;
        }

        @Override
        public void swap(int indexA, int indexB) {
            int ia = indexA * 3;
            int ib = indexB * 3;
            double tx = this.coordinates[ia + 0];
            double ty = this.coordinates[ia + 1];
            double tz = this.coordinates[ia + 2];
            this.coordinates[ia + 0] = this.coordinates[ib + 0];
            this.coordinates[ia + 1] = this.coordinates[ib + 1];
            this.coordinates[ia + 2] = this.coordinates[ib + 2];
            this.coordinates[ib + 0] = tx;
            this.coordinates[ib + 1] = ty;
            this.coordinates[ib + 2] = tz;
        }

        public int compare(int leftIndex, int rightIndex) {
            int i = leftIndex * 3;
            int j = rightIndex * 3;
            int cmp = Double.compare(this.coordinates[i + 0], this.coordinates[j]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(this.coordinates[i + 1], this.coordinates[j + 1]);
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(this.coordinates[i + 2], this.coordinates[j + 2]);
        }
    }

    public static interface PointOffsetVisitor {
        public boolean accept(int var1, double var2, double var4, double var6);
    }

    public static interface PointVisitor {
        public boolean accept(double var1, double var3, double var5);
    }

    public static class MutableS2PointImpl
    implements MutableS2Point {
        private double x;
        private double y;
        private double z;

        @Override
        public void set(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public void set(S2Point other) {
            this.x = other.getX();
            this.y = other.getY();
            this.z = other.getZ();
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getX() {
            return this.x;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }
    }
}

