/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.tracing.opentelemetry.advice;

import org.apache.shardingsphere.agent.api.advice.TargetAdviceMethod;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceObject;
import org.apache.shardingsphere.agent.plugin.tracing.core.advice.TracingJDBCExecutorCallbackAdvice;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.shade.io.opentelemetry.api.GlobalOpenTelemetry;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.Span;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.SpanBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.StatusCode;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.Tracer;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;

public final class OpenTelemetryJDBCExecutorCallbackAdvice
extends TracingJDBCExecutorCallbackAdvice<Span> {
    @Override
    protected void recordExecuteInfo(Span parentSpan, TargetAdviceObject target, JDBCExecutionUnit executionUnit, boolean isTrunkThread, ConnectionProperties connectionProps, DatabaseType databaseType) {
        Tracer tracer = GlobalOpenTelemetry.getTracer("shardingsphere-agent");
        SpanBuilder spanBuilder = tracer.spanBuilder("/ShardingSphere/executeSQL/");
        if (null != parentSpan) {
            spanBuilder.setParent(Context.current().with(parentSpan));
        }
        spanBuilder.setAttribute("component", "ShardingSphere");
        spanBuilder.setAttribute("db.type", databaseType.getType());
        spanBuilder.setAttribute("db.instance", executionUnit.getExecutionUnit().getDataSourceName()).setAttribute("peer.hostname", connectionProps.getHostname()).setAttribute("peer.port", String.valueOf(connectionProps.getPort())).setAttribute("db.statement", executionUnit.getExecutionUnit().getSqlUnit().getSql()).setAttribute("db.bind_vars", executionUnit.getExecutionUnit().getSqlUnit().getParameters().toString()).setAttribute("span.kind", "client");
        target.setAttachment((Object)spanBuilder.startSpan());
    }

    public void afterMethod(TargetAdviceObject target, TargetAdviceMethod method, Object[] args, Object result, String pluginType) {
        Span span = (Span)target.getAttachment();
        if (null != span) {
            span.setStatus(StatusCode.OK);
            span.end();
        }
    }

    public void onThrowing(TargetAdviceObject target, TargetAdviceMethod method, Object[] args, Throwable throwable, String pluginType) {
        Span span = (Span)target.getAttachment();
        if (null != span) {
            span.setStatus(StatusCode.ERROR).recordException(throwable);
            span.end();
        }
    }
}

