/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.samplers;

import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.samplers.ParentBasedSampler;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.samplers.Sampler;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.samplers.TraceIdRatioBasedSampler;

public final class ParentBasedSamplerBuilder {
    private static final Logger logger = Logger.getLogger(ParentBasedSamplerBuilder.class.getName());
    private final Sampler root;
    @Nullable
    private Sampler remoteParentSampled;
    @Nullable
    private Sampler remoteParentNotSampled;
    @Nullable
    private Sampler localParentSampled;
    @Nullable
    private Sampler localParentNotSampled;

    ParentBasedSamplerBuilder(Sampler root) {
        ParentBasedSamplerBuilder.maybeLogTraceIdSamplerWarning(root, "root");
        this.root = root;
    }

    public ParentBasedSamplerBuilder setRemoteParentSampled(Sampler remoteParentSampled) {
        ParentBasedSamplerBuilder.maybeLogTraceIdSamplerWarning(remoteParentSampled, "remoteParentSampled");
        this.remoteParentSampled = remoteParentSampled;
        return this;
    }

    public ParentBasedSamplerBuilder setRemoteParentNotSampled(Sampler remoteParentNotSampled) {
        ParentBasedSamplerBuilder.maybeLogTraceIdSamplerWarning(remoteParentNotSampled, "remoteParentNotSampled");
        this.remoteParentNotSampled = remoteParentNotSampled;
        return this;
    }

    public ParentBasedSamplerBuilder setLocalParentSampled(Sampler localParentSampled) {
        ParentBasedSamplerBuilder.maybeLogTraceIdSamplerWarning(localParentSampled, "localParentSampled");
        this.localParentSampled = localParentSampled;
        return this;
    }

    public ParentBasedSamplerBuilder setLocalParentNotSampled(Sampler localParentNotSampled) {
        ParentBasedSamplerBuilder.maybeLogTraceIdSamplerWarning(localParentNotSampled, "localParentNotSampled");
        this.localParentNotSampled = localParentNotSampled;
        return this;
    }

    private static void maybeLogTraceIdSamplerWarning(Sampler sampler, String field) {
        if (sampler instanceof TraceIdRatioBasedSampler) {
            logger.warning("TraceIdRatioBasedSampler is being used as a child sampler (" + field + "). This configuration is discouraged per the OpenTelemetry specification and may lead to unexpected sampling behavior.");
        }
    }

    public Sampler build() {
        return new ParentBasedSampler(this.root, this.remoteParentSampled, this.remoteParentNotSampled, this.localParentSampled, this.localParentNotSampled);
    }
}

