/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.projection;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.enums.EncryptDerivedColumnSuffix;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.AssistedQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.column.item.LikeQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TableSourceType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParenthesesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptProjectionTokenGenerator {
    private final List<SQLToken> previousSQLTokens;
    private final DatabaseType databaseType;
    private final EncryptRule rule;
    private final DialectDatabaseMetaData dialectDatabaseMetaData;

    public EncryptProjectionTokenGenerator(List<SQLToken> previousSQLTokens, DatabaseType databaseType, EncryptRule rule) {
        this.previousSQLTokens = previousSQLTokens;
        this.databaseType = databaseType;
        this.rule = rule;
        this.dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
    }

    public Collection<SQLToken> generateSQLTokens(SelectStatementContext selectStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        selectStatementContext.getSubqueryContexts().values().forEach(each -> result.addAll(this.generateSQLTokens((SelectStatementContext)each)));
        result.addAll(this.generateSelectSQLTokens(selectStatementContext));
        return result;
    }

    private Collection<SQLToken> generateSelectSQLTokens(SelectStatementContext selectStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ProjectionSegment each : selectStatementContext.getSqlStatement().getProjections().getProjections()) {
            ShorthandProjectionSegment shorthandSegment;
            Collection actualColumns;
            if (each instanceof ColumnProjectionSegment) {
                this.generateSQLToken(selectStatementContext, (ColumnProjectionSegment)each).ifPresent(result::add);
                continue;
            }
            if (!(each instanceof ShorthandProjectionSegment) || (actualColumns = this.getShorthandProjection(shorthandSegment = (ShorthandProjectionSegment)each, selectStatementContext.getProjectionsContext()).getActualColumns()).isEmpty()) continue;
            result.add((SQLToken)this.generateSQLToken(shorthandSegment, actualColumns, selectStatementContext.getSqlStatement().getDatabaseType(), selectStatementContext.getSubqueryType()));
        }
        return result;
    }

    private Optional<SubstitutableColumnNameToken> generateSQLToken(SelectStatementContext selectStatementContext, ColumnProjectionSegment columnSegment) {
        ColumnProjection columnProjection = this.buildColumnProjection(columnSegment);
        String columnName = columnProjection.getOriginalColumn().getValue();
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(columnProjection.getOriginalTable().getValue());
        if (encryptTable.isPresent() && encryptTable.get().isEncryptColumn(columnName)) {
            EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(columnName);
            Collection<Projection> projections = this.generateProjections(encryptColumn, columnProjection, selectStatementContext.getSubqueryType());
            int startIndex = this.getStartIndex(columnSegment);
            int stopIndex = this.getStopIndex(columnSegment);
            this.previousSQLTokens.removeIf(each -> each.getStartIndex() == startIndex);
            return Optional.of(new SubstitutableColumnNameToken(startIndex, stopIndex, projections, this.databaseType));
        }
        return Optional.empty();
    }

    private SubstitutableColumnNameToken generateSQLToken(ShorthandProjectionSegment segment, Collection<Projection> actualColumns, DatabaseType databaseType, SubqueryType subqueryType) {
        LinkedList<Projection> projections = new LinkedList<Projection>();
        for (Projection each2 : actualColumns) {
            ColumnProjection columnProjection;
            Optional<EncryptTable> encryptTable;
            if (each2 instanceof ColumnProjection && (encryptTable = this.rule.findEncryptTable((columnProjection = (ColumnProjection)each2).getOriginalTable().getValue())).isPresent() && encryptTable.get().isEncryptColumn(columnProjection.getOriginalColumn().getValue())) {
                EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(columnProjection.getOriginalColumn().getValue());
                projections.addAll(this.generateProjections(encryptColumn, columnProjection, subqueryType));
                continue;
            }
            projections.add(each2.getAlias().filter(alias -> !DerivedColumn.isDerivedColumnName((String)alias.getValue())).map(optional -> new ColumnProjection(null, optional, null, databaseType)).orElse(each2));
        }
        int startIndex = segment.getOwner().isPresent() ? ((OwnerSegment)segment.getOwner().get()).getStartIndex() : segment.getStartIndex();
        this.previousSQLTokens.removeIf(each -> each.getStartIndex() == startIndex);
        return new SubstitutableColumnNameToken(startIndex, segment.getStopIndex(), projections, databaseType);
    }

    private int getStartIndex(ColumnProjectionSegment columnSegment) {
        if (columnSegment.getColumn().getLeftParentheses().isPresent()) {
            return ((ParenthesesSegment)columnSegment.getColumn().getLeftParentheses().get()).getStartIndex();
        }
        return columnSegment.getColumn().getOwner().isPresent() ? ((OwnerSegment)columnSegment.getColumn().getOwner().get()).getStartIndex() : columnSegment.getColumn().getStartIndex();
    }

    private int getStopIndex(ColumnProjectionSegment columnSegment) {
        if (columnSegment.getAliasSegment().isPresent()) {
            return ((AliasSegment)columnSegment.getAliasSegment().get()).getStopIndex();
        }
        return columnSegment.getColumn().getRightParentheses().isPresent() ? ((ParenthesesSegment)columnSegment.getColumn().getRightParentheses().get()).getStopIndex() : columnSegment.getColumn().getStopIndex();
    }

    private ColumnProjection buildColumnProjection(ColumnProjectionSegment segment) {
        IdentifierValue owner = segment.getColumn().getOwner().map(OwnerSegment::getIdentifier).orElse(null);
        return new ColumnProjection(owner, segment.getColumn().getIdentifier(), segment.getAliasName().isPresent() ? (IdentifierValue)segment.getAlias().orElse(null) : null, this.databaseType, (ParenthesesSegment)segment.getColumn().getLeftParentheses().orElse(null), (ParenthesesSegment)segment.getColumn().getRightParentheses().orElse(null), segment.getColumn().getColumnBoundInfo());
    }

    private Collection<Projection> generateProjections(EncryptColumn encryptColumn, ColumnProjection columnProjection, SubqueryType subqueryType) {
        if (null == subqueryType || SubqueryType.PROJECTION == subqueryType) {
            return Collections.singleton(this.generateProjection(encryptColumn, columnProjection));
        }
        if (SubqueryType.TABLE == subqueryType || SubqueryType.JOIN == subqueryType || SubqueryType.WITH == subqueryType) {
            return this.generateProjectionsInTableSegmentSubquery(encryptColumn, columnProjection);
        }
        if (SubqueryType.PREDICATE == subqueryType) {
            return Collections.singleton(this.generateProjectionInPredicateSubquery(encryptColumn, columnProjection));
        }
        if (SubqueryType.INSERT_SELECT == subqueryType || SubqueryType.VIEW_DEFINITION == subqueryType) {
            return this.generateProjectionsInInsertSelectSubquery(encryptColumn, columnProjection);
        }
        throw new UnsupportedSQLOperationException("Projections not in simple select, table subquery, join subquery, predicate subquery and insert select subquery are not supported in encrypt feature.");
    }

    private ColumnProjection generateProjection(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        String encryptColumnName = this.getEncryptColumnName(columnProjection, encryptColumn);
        QuoteCharacter quoteCharacter = this.getQuoteCharacter(columnProjection);
        IdentifierValue cipherColumnName = new IdentifierValue(encryptColumnName, quoteCharacter);
        IdentifierValue cipherColumnAlias = columnProjection.getAlias().orElse(columnProjection.getName());
        return new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), cipherColumnName, cipherColumnAlias, this.databaseType, (ParenthesesSegment)columnProjection.getLeftParentheses().orElse(null), (ParenthesesSegment)columnProjection.getRightParentheses().orElse(null));
    }

    private QuoteCharacter getQuoteCharacter(ColumnProjection columnProjection) {
        return TableSourceType.PHYSICAL_TABLE == columnProjection.getColumnBoundInfo().getTableSourceType() ? this.dialectDatabaseMetaData.getQuoteCharacter() : columnProjection.getName().getQuoteCharacter();
    }

    private String getEncryptColumnName(ColumnProjection columnProjection, EncryptColumn encryptColumn) {
        IdentifierValue columnName = columnProjection.getName();
        return TableSourceType.TEMPORARY_TABLE == columnProjection.getColumnBoundInfo().getTableSourceType() ? EncryptDerivedColumnSuffix.CIPHER.getDerivedColumnName(columnName.getValue(), this.databaseType) : encryptColumn.getCipher().getName();
    }

    private Collection<Projection> generateProjectionsInTableSegmentSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        return this.generateCipherProjectionsInTableSegmentSubquery(encryptColumn, columnProjection);
    }

    private Collection<Projection> generateCipherProjectionsInTableSegmentSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        IdentifierValue cipherColumnName = TableSourceType.TEMPORARY_TABLE == columnProjection.getColumnBoundInfo().getTableSourceType() ? new IdentifierValue(EncryptDerivedColumnSuffix.CIPHER.getDerivedColumnName(columnProjection.getName().getValue(), this.databaseType), columnProjection.getName().getQuoteCharacter()) : new IdentifierValue(encryptColumn.getCipher().getName(), columnProjection.getName().getQuoteCharacter());
        IdentifierValue columnAlias = columnProjection.getAlias().orElse(columnProjection.getName());
        IdentifierValue cipherColumnAlias = this.getEncryptColumnAliasInTableSegmentSubquery(columnProjection, columnAlias, EncryptDerivedColumnSuffix.CIPHER);
        result.add((Projection)new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), cipherColumnName, cipherColumnAlias, this.databaseType));
        encryptColumn.getAssistedQuery().ifPresent(optional -> this.addAssistedQueryColumn(columnProjection, (AssistedQueryColumnItem)optional, columnAlias, (Collection<Projection>)result));
        encryptColumn.getLikeQuery().ifPresent(optional -> this.addLikeQueryColumn(columnProjection, (LikeQueryColumnItem)optional, columnAlias, (Collection<Projection>)result));
        return result;
    }

    private IdentifierValue getEncryptColumnAliasInTableSegmentSubquery(ColumnProjection columnProjection, IdentifierValue columnAlias, EncryptDerivedColumnSuffix suffix) {
        if (TableSourceType.TEMPORARY_TABLE == columnProjection.getColumnBoundInfo().getTableSourceType()) {
            return columnProjection.getAlias().map(optional -> new IdentifierValue(suffix.getDerivedColumnName(optional.getValue(), this.databaseType), optional.getQuoteCharacter())).orElse(null);
        }
        return new IdentifierValue(suffix.getDerivedColumnName(columnAlias.getValue(), this.databaseType), columnAlias.getQuoteCharacter());
    }

    private void addAssistedQueryColumn(ColumnProjection columnProjection, AssistedQueryColumnItem assistedQueryColumnItem, IdentifierValue columnAlias, Collection<Projection> result) {
        IdentifierValue assistedQueryName = TableSourceType.TEMPORARY_TABLE == columnProjection.getColumnBoundInfo().getTableSourceType() ? new IdentifierValue(EncryptDerivedColumnSuffix.ASSISTED_QUERY.getDerivedColumnName(columnProjection.getName().getValue(), this.databaseType), columnProjection.getName().getQuoteCharacter()) : new IdentifierValue(assistedQueryColumnItem.getName(), columnProjection.getName().getQuoteCharacter());
        IdentifierValue assistedQueryAlias = this.getEncryptColumnAliasInTableSegmentSubquery(columnProjection, columnAlias, EncryptDerivedColumnSuffix.ASSISTED_QUERY);
        result.add((Projection)new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), assistedQueryName, assistedQueryAlias, this.databaseType, (ParenthesesSegment)columnProjection.getLeftParentheses().orElse(null), (ParenthesesSegment)columnProjection.getRightParentheses().orElse(null)));
    }

    private void addLikeQueryColumn(ColumnProjection columnProjection, LikeQueryColumnItem likeQueryColumnItem, IdentifierValue columnAlias, Collection<Projection> result) {
        IdentifierValue likeQueryName = TableSourceType.TEMPORARY_TABLE == columnProjection.getColumnBoundInfo().getTableSourceType() ? new IdentifierValue(EncryptDerivedColumnSuffix.LIKE_QUERY.getDerivedColumnName(columnProjection.getName().getValue(), this.databaseType), columnProjection.getName().getQuoteCharacter()) : new IdentifierValue(likeQueryColumnItem.getName(), columnProjection.getName().getQuoteCharacter());
        IdentifierValue likeQueryAlias = this.getEncryptColumnAliasInTableSegmentSubquery(columnProjection, columnAlias, EncryptDerivedColumnSuffix.LIKE_QUERY);
        result.add((Projection)new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), likeQueryName, likeQueryAlias, this.databaseType, (ParenthesesSegment)columnProjection.getLeftParentheses().orElse(null), (ParenthesesSegment)columnProjection.getRightParentheses().orElse(null)));
    }

    private ColumnProjection generateProjectionInPredicateSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        ParenthesesSegment leftParentheses = columnProjection.getLeftParentheses().orElse(null);
        ParenthesesSegment rightParentheses = columnProjection.getRightParentheses().orElse(null);
        IdentifierValue owner = columnProjection.getOwner().orElse(null);
        return encryptColumn.getAssistedQuery().map(optional -> new ColumnProjection(owner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)).orElseGet(() -> new ColumnProjection(owner, new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter), columnProjection.getAlias().orElse(columnProjection.getName()), this.databaseType, leftParentheses, rightParentheses));
    }

    private Collection<Projection> generateProjectionsInInsertSelectSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        IdentifierValue columnName = new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter);
        LinkedList<Projection> result = new LinkedList<Projection>();
        ParenthesesSegment leftParentheses = columnProjection.getLeftParentheses().orElse(null);
        ParenthesesSegment rightParentheses = columnProjection.getRightParentheses().orElse(null);
        result.add((Projection)new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), columnName, null, this.databaseType, leftParentheses, rightParentheses));
        IdentifierValue columOwner = columnProjection.getOwner().orElse(null);
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(columOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(columOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)));
        return result;
    }

    private ShorthandProjection getShorthandProjection(ShorthandProjectionSegment segment, ProjectionsContext projectionsContext) {
        Optional owner = segment.getOwner().isPresent() ? Optional.of(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue()) : Optional.empty();
        for (Projection each : projectionsContext.getProjections()) {
            if (!(each instanceof ShorthandProjection)) continue;
            if (!owner.isPresent() && !((ShorthandProjection)each).getOwner().isPresent()) {
                return (ShorthandProjection)each;
            }
            if (!owner.isPresent() || !((String)owner.get()).equals(((ShorthandProjection)each).getOwner().map(IdentifierValue::getValue).orElse(null))) continue;
            return (ShorthandProjection)each;
        }
        throw new IllegalStateException(String.format("Can not find shorthand projection segment, owner is `%s`", owner.orElse(null)));
    }

    @Generated
    public EncryptProjectionTokenGenerator(List<SQLToken> previousSQLTokens, DatabaseType databaseType, EncryptRule rule, DialectDatabaseMetaData dialectDatabaseMetaData) {
        this.previousSQLTokens = previousSQLTokens;
        this.databaseType = databaseType;
        this.rule = rule;
        this.dialectDatabaseMetaData = dialectDatabaseMetaData;
    }
}

