/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.rule.changed;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.rule.MaskRule;
import org.apache.shardingsphere.mask.yaml.config.rule.YamlMaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.yaml.swapper.rule.YamlMaskTableRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;

public final class MaskTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<MaskRuleConfiguration, MaskTableRuleConfiguration> {
    public MaskTableRuleConfiguration swapRuleItemConfiguration(String itemName, String yamlContent) {
        return new YamlMaskTableRuleConfigurationSwapper().swapToObject((YamlMaskTableRuleConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlMaskTableRuleConfiguration.class));
    }

    public MaskRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(MaskRule.class).map(MaskRule::getConfiguration).orElseGet(() -> new MaskRuleConfiguration(new LinkedList(), new LinkedHashMap()));
    }

    public void changeRuleItemConfiguration(String itemName, MaskRuleConfiguration currentRuleConfig, MaskTableRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().removeIf(each -> each.getName().equals(toBeChangedItemConfig.getName()));
        currentRuleConfig.getTables().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(String itemName, MaskRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().removeIf(each -> each.getName().equals(itemName));
    }

    public RuleChangedItemType getType() {
        return new RuleChangedItemType("mask", "tables");
    }
}

