/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata;

import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.DatabaseLeafValueChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.statistics.StatisticsRefreshEngine;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.schema.SchemaMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.schema.TableMetaDataNodePath;

public final class TableChangedHandler
implements DatabaseLeafValueChangedHandler {
    private final ContextManager contextManager;
    private final StatisticsRefreshEngine statisticsRefreshEngine;

    public TableChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.statisticsRefreshEngine = new StatisticsRefreshEngine(contextManager);
    }

    @Override
    public NodePath getSubscribedNodePath(String databaseName) {
        return new TableMetaDataNodePath(databaseName, "([\\w-]+)", "([\\w-]+)");
    }

    @Override
    public void handle(String databaseName, DataChangedEvent event) {
        String schemaName = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)SchemaMetaDataNodePath.createSchemaSearchCriteria((String)databaseName, (boolean)true));
        String tableName = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)TableMetaDataNodePath.createTableSearchCriteria((String)databaseName, (String)schemaName));
        switch (event.getType()) {
            case ADDED: 
            case UPDATED: {
                this.handleCreatedOrAltered(databaseName, schemaName, tableName);
                break;
            }
            case DELETED: {
                this.handleDropped(databaseName, schemaName, tableName);
                break;
            }
        }
    }

    private void handleCreatedOrAltered(String databaseName, String schemaName, String tableName) {
        Optional table = this.contextManager.getPersistServiceFacade().getMetaDataFacade().getDatabaseMetaDataFacade().getTable().load(databaseName, schemaName, tableName);
        if (table.isPresent()) {
            this.contextManager.getMetaDataContextManager().getDatabaseMetaDataManager().alterTable(databaseName, schemaName, (ShardingSphereTable)table.get());
            this.statisticsRefreshEngine.asyncRefresh();
        }
    }

    private void handleDropped(String databaseName, String schemaName, String tableName) {
        this.contextManager.getMetaDataContextManager().getDatabaseMetaDataManager().dropTable(databaseName, schemaName, tableName);
        this.statisticsRefreshEngine.asyncRefresh();
    }
}

