/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context;

import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.DialectCommonSQLStatementContextWarpProvider;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dal.ExplainStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.AlterViewStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.CreateProcedureStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.CreateViewStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.CursorHeldSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.CursorStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.DeleteStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.CursorSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ExplainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.CursorStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.CreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;

public final class SQLStatementContextFactory {
    public static SQLStatementContext newInstance(ShardingSphereMetaData metaData, SQLStatement sqlStatement, String currentDatabaseName) {
        if (sqlStatement.getAttributes().findAttribute(TableSQLStatementAttribute.class).isPresent() && DatabaseTypedSPILoader.findService(DialectCommonSQLStatementContextWarpProvider.class, (DatabaseType)sqlStatement.getDatabaseType()).map(optional -> optional.getNeedToWarpSQLStatementTypes().contains(sqlStatement.getClass())).orElse(false).booleanValue()) {
            return new CommonSQLStatementContext(sqlStatement);
        }
        if (sqlStatement instanceof DMLStatement) {
            return SQLStatementContextFactory.getDMLStatementContext(metaData, (DMLStatement)sqlStatement, currentDatabaseName);
        }
        if (sqlStatement instanceof DDLStatement) {
            return SQLStatementContextFactory.getDDLStatementContext(metaData, (DDLStatement)sqlStatement, currentDatabaseName);
        }
        if (sqlStatement instanceof DCLStatement) {
            return SQLStatementContextFactory.getDCLStatementContext((DCLStatement)sqlStatement);
        }
        if (sqlStatement instanceof DALStatement) {
            return SQLStatementContextFactory.getDALStatementContext(metaData, (DALStatement)sqlStatement, currentDatabaseName);
        }
        return new CommonSQLStatementContext(sqlStatement);
    }

    private static SQLStatementContext getDMLStatementContext(ShardingSphereMetaData metaData, DMLStatement sqlStatement, String currentDatabaseName) {
        if (sqlStatement instanceof SelectStatement) {
            return new SelectStatementContext((SelectStatement)sqlStatement, metaData, currentDatabaseName, Collections.emptyList());
        }
        if (sqlStatement instanceof UpdateStatement) {
            return new UpdateStatementContext((UpdateStatement)sqlStatement);
        }
        if (sqlStatement instanceof DeleteStatement) {
            return new DeleteStatementContext((DeleteStatement)sqlStatement);
        }
        if (sqlStatement instanceof InsertStatement) {
            return new InsertStatementContext((InsertStatement)sqlStatement, metaData, currentDatabaseName);
        }
        return new CommonSQLStatementContext((SQLStatement)sqlStatement);
    }

    private static SQLStatementContext getDDLStatementContext(ShardingSphereMetaData metaData, DDLStatement sqlStatement, String currentDatabaseName) {
        if (sqlStatement instanceof CreateProcedureStatement) {
            return new CreateProcedureStatementContext((CreateProcedureStatement)sqlStatement);
        }
        if (sqlStatement instanceof CreateViewStatement) {
            return new CreateViewStatementContext(metaData, (CreateViewStatement)sqlStatement, currentDatabaseName);
        }
        if (sqlStatement instanceof AlterViewStatement) {
            return new AlterViewStatementContext(metaData, (AlterViewStatement)sqlStatement, currentDatabaseName);
        }
        if (sqlStatement instanceof CursorStatement) {
            return new CursorStatementContext(metaData, (CursorStatement)sqlStatement, currentDatabaseName);
        }
        if (sqlStatement.getAttributes().findAttribute(CursorSQLStatementAttribute.class).isPresent()) {
            return new CursorHeldSQLStatementContext((SQLStatement)sqlStatement);
        }
        return new CommonSQLStatementContext((SQLStatement)sqlStatement);
    }

    private static SQLStatementContext getDCLStatementContext(DCLStatement sqlStatement) {
        return new CommonSQLStatementContext((SQLStatement)sqlStatement);
    }

    private static SQLStatementContext getDALStatementContext(ShardingSphereMetaData metaData, DALStatement sqlStatement, String currentDatabaseName) {
        if (sqlStatement instanceof ExplainStatement) {
            return new ExplainStatementContext(metaData, (ExplainStatement)sqlStatement, currentDatabaseName);
        }
        return new CommonSQLStatementContext((SQLStatement)sqlStatement);
    }

    @Generated
    private SQLStatementContextFactory() {
    }
}

