/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.type.dml;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;

public final class DeleteStatementBaseContext
implements SQLStatementContext {
    private final DeleteStatement sqlStatement;
    private final TablesContext tablesContext;
    private final Collection<WhereSegment> whereSegments;
    private final Collection<ColumnSegment> columnSegments;
    private final Collection<BinaryOperationExpression> joinConditions = new LinkedList<BinaryOperationExpression>();

    public DeleteStatementBaseContext(DeleteStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
        this.tablesContext = new TablesContext(this.getAllSimpleTableSegments());
        this.whereSegments = this.createWhereSegments(sqlStatement);
        this.columnSegments = ColumnExtractor.extractColumnSegments(this.whereSegments);
        ExpressionExtractor.extractJoinConditions(this.joinConditions, this.whereSegments);
    }

    private Collection<WhereSegment> createWhereSegments(DeleteStatement deleteStatement) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        deleteStatement.getWhere().ifPresent(result::add);
        return result;
    }

    private Collection<SimpleTableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromDelete(this.sqlStatement);
        return this.filterAliasDeleteTable(tableExtractor.getRewriteTables());
    }

    private Collection<SimpleTableSegment> filterAliasDeleteTable(Collection<SimpleTableSegment> tableSegments) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        Map<String, SimpleTableSegment> aliasAndTableSegmentMap = this.getAliasAndTableSegmentMap(tableSegments);
        for (SimpleTableSegment each : tableSegments) {
            SimpleTableSegment aliasDeleteTable = aliasAndTableSegmentMap.get(each.getTableName().getIdentifier().getValue());
            if (null != aliasDeleteTable && !aliasDeleteTable.equals(each)) continue;
            result.add(each);
        }
        return result;
    }

    private Map<String, SimpleTableSegment> getAliasAndTableSegmentMap(Collection<SimpleTableSegment> tableSegments) {
        HashMap<String, SimpleTableSegment> result = new HashMap<String, SimpleTableSegment>(tableSegments.size(), 1.0f);
        for (SimpleTableSegment each : tableSegments) {
            each.getAliasName().ifPresent(optional -> result.putIfAbsent((String)optional, each));
        }
        return result;
    }

    @Generated
    public DeleteStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    @Generated
    public Collection<ColumnSegment> getColumnSegments() {
        return this.columnSegments;
    }

    @Generated
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return this.joinConditions;
    }
}

