/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.rule.attribute;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.single.rule.attribute.SingleTableMapperRuleAttribute;
import org.apache.shardingsphere.single.util.SingleTableLoadUtils;

public final class SingleMutableDataNodeRuleAttribute
implements MutableDataNodeRuleAttribute {
    private final SingleRuleConfiguration configuration;
    private final Collection<String> dataSourceNames;
    private final Map<String, Collection<DataNode>> singleTableDataNodes;
    private final DatabaseType protocolType;
    private final SingleTableMapperRuleAttribute tableMapperRuleAttribute;

    public void put(String dataSourceName, String schemaName, String tableName) {
        if (this.dataSourceNames.contains(dataSourceName)) {
            Collection dataNodes = this.singleTableDataNodes.computeIfAbsent(tableName.toLowerCase(), key -> new LinkedHashSet());
            dataNodes.add(new DataNode(dataSourceName, schemaName, tableName));
            this.tableMapperRuleAttribute.getLogicTableNames().add(tableName);
            this.addTableConfiguration(dataSourceName, schemaName, tableName);
        }
    }

    private void addTableConfiguration(String dataSourceName, String schemaName, String tableName) {
        Collection<String> splitTables = SingleTableLoadUtils.splitTableLines(this.configuration.getTables());
        if (splitTables.contains(SingleTableLoadUtils.getAllTablesNodeStr(this.protocolType)) || splitTables.contains(SingleTableLoadUtils.getAllTablesNodeStrFromDataSource(this.protocolType, dataSourceName, schemaName))) {
            return;
        }
        String dataNodeString = SingleTableLoadUtils.getDataNodeString(this.protocolType, dataSourceName, schemaName, tableName);
        if (!this.configuration.getTables().contains(dataNodeString)) {
            this.configuration.getTables().add(dataNodeString);
        }
    }

    public void remove(String schemaName, String tableName) {
        this.remove(Collections.singleton(schemaName.toLowerCase()), tableName);
    }

    public void remove(Collection<String> schemaNames, String tableName) {
        if (!this.singleTableDataNodes.containsKey(tableName.toLowerCase())) {
            return;
        }
        Collection<DataNode> dataNodes = this.singleTableDataNodes.get(tableName.toLowerCase());
        Iterator<DataNode> iterator = dataNodes.iterator();
        while (iterator.hasNext()) {
            DataNode each = iterator.next();
            if (!schemaNames.contains(each.getSchemaName().toLowerCase())) continue;
            iterator.remove();
            this.configuration.getTables().remove(SingleTableLoadUtils.getDataNodeString(this.protocolType, each.getDataSourceName(), each.getSchemaName(), tableName));
        }
        if (dataNodes.isEmpty()) {
            this.singleTableDataNodes.remove(tableName.toLowerCase());
            this.tableMapperRuleAttribute.getLogicTableNames().remove(tableName);
        }
    }

    public Optional<DataNode> findTableDataNode(String schemaName, String tableName) {
        Collection dataNodes = this.singleTableDataNodes.getOrDefault(tableName.toLowerCase(), new LinkedHashSet());
        for (DataNode each : dataNodes) {
            if (!schemaName.equalsIgnoreCase(each.getSchemaName())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public ShardingSphereRule reloadRule(RuleConfiguration ruleConfig, String databaseName, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        return new SingleRule((SingleRuleConfiguration)ruleConfig, databaseName, this.protocolType, dataSourceMap, builtRules);
    }

    @Generated
    public SingleMutableDataNodeRuleAttribute(SingleRuleConfiguration configuration, Collection<String> dataSourceNames, Map<String, Collection<DataNode>> singleTableDataNodes, DatabaseType protocolType, SingleTableMapperRuleAttribute tableMapperRuleAttribute) {
        this.configuration = configuration;
        this.dataSourceNames = dataSourceNames;
        this.singleTableDataNodes = singleTableDataNodes;
        this.protocolType = protocolType;
        this.tableMapperRuleAttribute = tableMapperRuleAttribute;
    }
}

