/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.HashColumn;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.impl.ConditionValueBetweenOperatorGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.impl.ConditionValueCompareOperatorGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.impl.ConditionValueInOperatorGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.timeservice.core.rule.TimestampServiceRule;

public final class ConditionValueGeneratorFactory {
    private static final ConditionValueCompareOperatorGenerator COMPARE_OPERATOR_GENERATOR = new ConditionValueCompareOperatorGenerator();
    private static final ConditionValueInOperatorGenerator IN_OPERATOR_GENERATOR = new ConditionValueInOperatorGenerator();
    private static final ConditionValueBetweenOperatorGenerator BETWEEN_OPERATOR_GENERATOR = new ConditionValueBetweenOperatorGenerator();

    public static Optional<ShardingConditionValue> generate(ExpressionSegment predicate, HashColumn column, List<Object> params, TimestampServiceRule timestampServiceRule) {
        if (predicate instanceof BinaryOperationExpression) {
            return COMPARE_OPERATOR_GENERATOR.generate((BinaryOperationExpression)predicate, column, params, timestampServiceRule);
        }
        if (predicate instanceof InExpression) {
            return IN_OPERATOR_GENERATOR.generate((InExpression)predicate, column, params, timestampServiceRule);
        }
        if (predicate instanceof BetweenExpression) {
            return BETWEEN_OPERATOR_GENERATOR.generate((BetweenExpression)predicate, column, params, timestampServiceRule);
        }
        return Optional.empty();
    }

    @Generated
    private ConditionValueGeneratorFactory() {
    }
}

