/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process.lock;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.shardingsphere.infra.executor.sql.process.lock.ProcessOperationLockReleaseStrategy;

public final class ProcessOperationLock {
    private static final long TIMEOUT_MILLIS = 5000L;
    private final CountDownLatch latch;

    public ProcessOperationLock(int latchCount) {
        this.latch = new CountDownLatch(latchCount);
    }

    public boolean awaitDefaultTime(ProcessOperationLockReleaseStrategy releaseStrategy) {
        if (releaseStrategy.isReadyToRelease()) {
            return true;
        }
        return this.latch.await(5000L, TimeUnit.MILLISECONDS);
    }

    public void doNotify() {
        this.latch.countDown();
    }
}

