/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.sql92.jdbcurl;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.database.connector.core.exception.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;

public final class SQL92ConnectionPropertiesParser
implements ConnectionPropertiesParser {
    private static final int DEFAULT_PORT = -1;
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:.*", 2);

    public ConnectionProperties parse(String url, String username, String catalog) {
        Matcher matcher = URL_PATTERN.matcher(url);
        ShardingSpherePreconditions.checkState((boolean)matcher.find(), () -> new UnrecognizedDatabaseURLException(url, URL_PATTERN.pattern()));
        return new ConnectionProperties("", -1, "", null, new Properties());
    }

    public String getDatabaseType() {
        return "SQL92";
    }
}

