/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.planner.rule.transformation;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Arrays;
import java.util.Collection;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.shardingsphere.sqlfederation.compiler.planner.rule.transformation.ImmutablePushProjectIntoScanRule;
import org.apache.shardingsphere.sqlfederation.compiler.rel.operator.logical.LogicalScan;
import org.immutables.value.Value;

@Value.Enclosing
public final class PushProjectIntoScanRule
extends RelRule<Config>
implements TransformationRule {
    private static final Collection<String> SYSTEM_SCHEMAS = new CaseInsensitiveSet(Arrays.asList("information_schema", "performance_schema", "mysql", "sys", "shardingsphere", "pg_catalog"));
    private static final String CASE_FUNCTION_NAME = "CAST";

    private PushProjectIntoScanRule(Config config) {
        super((RelRule.Config)config);
    }

    public boolean matches(RelOptRuleCall call) {
        LogicalScan logicalScan = (LogicalScan)call.rel(1);
        for (String each : logicalScan.getTable().getQualifiedName()) {
            if (!SYSTEM_SCHEMAS.contains(each)) continue;
            return false;
        }
        LogicalProject logicalProject = (LogicalProject)call.rel(0);
        for (RexNode each : logicalProject.getProjects()) {
            if (!(each instanceof RexSubQuery) && !this.containsCastFunction(each)) continue;
            return false;
        }
        return true;
    }

    private boolean containsCastFunction(RexNode rexNode) {
        return rexNode instanceof RexCall && CASE_FUNCTION_NAME.equalsIgnoreCase(((RexCall)rexNode).getOperator().getName());
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalProject logicalProject = (LogicalProject)call.rel(0);
        LogicalScan logicalScan = (LogicalScan)call.rel(1);
        logicalScan.pushDown(logicalProject);
        call.transformTo((RelNode)logicalScan);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutablePushProjectIntoScanRule.Config.builder().description(PushProjectIntoScanRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(LogicalProject.class).inputs(new RelRule.OperandTransform[]{b1 -> b1.operand(LogicalScan.class).anyInputs()})).build();

        default public PushProjectIntoScanRule toRule() {
            return new PushProjectIntoScanRule(this);
        }
    }
}

