/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.mysql;

import java.util.Optional;
import org.apache.shardingsphere.infra.route.engine.tableless.DialectDALStatementBroadcastRouteDecider;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.AllowNotUseDatabaseSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLAlterResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLCreateResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLDropResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLSetResourceGroupStatement;

public final class MySQLDALStatementBroadcastRouteDecider
implements DialectDALStatementBroadcastRouteDecider {
    public boolean isDataSourceBroadcastRoute(DALStatement sqlStatement) {
        return false;
    }

    public boolean isInstanceBroadcastRoute(DALStatement sqlStatement) {
        Optional attribute = sqlStatement.getAttributes().findAttribute(AllowNotUseDatabaseSQLStatementAttribute.class);
        return this.isResourceGroupStatement(sqlStatement) || attribute.isPresent() && ((AllowNotUseDatabaseSQLStatementAttribute)attribute.get()).isAllowNotUseDatabase();
    }

    private boolean isResourceGroupStatement(DALStatement sqlStatement) {
        return sqlStatement instanceof MySQLCreateResourceGroupStatement || sqlStatement instanceof MySQLAlterResourceGroupStatement || sqlStatement instanceof MySQLDropResourceGroupStatement || sqlStatement instanceof MySQLSetResourceGroupStatement;
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

