/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.database.exception.postgresql.vendor.PostgreSQLVendorError;
import org.apache.shardingsphere.database.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.database.protocol.constant.CommonConstants;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.database.protocol.payload.PacketPayload;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.generic.PostgreSQLErrorResponsePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLPacketCodecEngine
implements DatabasePacketCodecEngine {
    private static final int SSL_REQUEST_PAYLOAD_LENGTH = 8;
    private static final int SSL_REQUEST_CODE = 80877103;
    private static final int MESSAGE_TYPE_LENGTH = 1;
    private static final int PAYLOAD_LENGTH = 4;
    private boolean startupPhase = true;
    private final List<ByteBuf> pendingMessages = new LinkedList<ByteBuf>();

    public boolean isValidHeader(int readableBytes) {
        return readableBytes >= (this.startupPhase ? 0 : 1) + 4;
    }

    public void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        while (this.isValidHeader(in.readableBytes())) {
            if (this.startupPhase) {
                this.handleStartupPhase(in, out);
                return;
            }
            int payloadLength = in.getInt(in.readerIndex() + 1);
            if (in.readableBytes() < 1 + payloadLength) {
                return;
            }
            byte type = in.getByte(in.readerIndex());
            PostgreSQLCommandPacketType commandPacketType = PostgreSQLCommandPacketType.valueOf(type);
            if (this.requireAggregation(commandPacketType)) {
                this.pendingMessages.add(in.readRetainedSlice(1 + payloadLength));
                continue;
            }
            if (this.pendingMessages.isEmpty()) {
                out.add(in.readRetainedSlice(1 + payloadLength));
                continue;
            }
            this.handlePendingMessages(context, in, out, payloadLength);
        }
    }

    private void handleStartupPhase(ByteBuf in, List<Object> out) {
        int readerIndex = in.readerIndex();
        if (in.readableBytes() == 8 && 8 == in.getInt(readerIndex) && 80877103 == in.getInt(readerIndex + 4)) {
            out.add(in.readRetainedSlice(8));
            return;
        }
        if (in.readableBytes() == in.getInt(readerIndex)) {
            out.add(in.readRetainedSlice(in.readableBytes()));
            this.startupPhase = false;
        }
    }

    private boolean requireAggregation(PostgreSQLCommandPacketType commandPacketType) {
        return PostgreSQLCommandPacketType.isExtendedProtocolPacketType(commandPacketType) && PostgreSQLCommandPacketType.SYNC_COMMAND != commandPacketType && PostgreSQLCommandPacketType.FLUSH_COMMAND != commandPacketType;
    }

    private void handlePendingMessages(ChannelHandlerContext context, ByteBuf in, List<Object> out, int payloadLength) {
        CompositeByteBuf result = context.alloc().compositeBuffer(this.pendingMessages.size() + 1);
        result.addComponents(true, this.pendingMessages).addComponent(true, in.readRetainedSlice(1 + payloadLength));
        out.add(result);
        this.pendingMessages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(ChannelHandlerContext context, DatabasePacket message, ByteBuf out) {
        boolean isIdentifierPacket = message instanceof PostgreSQLIdentifierPacket;
        if (isIdentifierPacket) {
            this.prepareMessageHeader(out, ((PostgreSQLIdentifierPacket)message).getIdentifier().getValue());
        }
        PostgreSQLPacketPayload payload = new PostgreSQLPacketPayload(out, (Charset)context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
        try {
            message.write((PacketPayload)payload);
        }
        catch (RuntimeException ex) {
            payload.getByteBuf().resetWriterIndex();
            PostgreSQLErrorResponsePacket errorResponsePacket = PostgreSQLErrorResponsePacket.newBuilder("ERROR", PostgreSQLVendorError.SYSTEM_ERROR, ex.getMessage()).build();
            isIdentifierPacket = true;
            this.prepareMessageHeader(out, errorResponsePacket.getIdentifier().getValue());
            errorResponsePacket.write((PacketPayload)payload);
        }
        finally {
            if (isIdentifierPacket) {
                this.updateMessageLength(out);
            }
        }
    }

    private void prepareMessageHeader(ByteBuf out, char type) {
        out.writeByte((int)type);
        out.writeInt(0);
    }

    private void updateMessageLength(ByteBuf out) {
        out.setInt(1, out.readableBytes() - 1);
    }

    public PostgreSQLPacketPayload createPacketPayload(ByteBuf message, Charset charset) {
        return new PostgreSQLPacketPayload(message, charset);
    }
}

