/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector.jdbc.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.protocol.parameter.TypeUnspecifiedSQLParameter;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.statement.StatementMemoryStrictlyFetchSizeSetter;

public final class JDBCBackendStatement
implements ExecutorJDBCStatementManager {
    public Statement createStorageResource(Connection connection, ConnectionMode connectionMode, StatementOption option, DatabaseType databaseType) throws SQLException {
        Statement result = connection.createStatement();
        if (ConnectionMode.MEMORY_STRICTLY == connectionMode) {
            this.setFetchSize(result, databaseType);
        }
        return result;
    }

    public Statement createStorageResource(ExecutionUnit executionUnit, Connection connection, int connectionOffset, ConnectionMode connectionMode, StatementOption option, DatabaseType databaseType) throws SQLException {
        String sql = executionUnit.getSqlUnit().getSql();
        List params = executionUnit.getSqlUnit().getParameters();
        PreparedStatement result = option.isReturnGeneratedKeys() ? connection.prepareStatement(executionUnit.getSqlUnit().getSql(), 1) : connection.prepareStatement(sql);
        Iterator paramIterator = params.iterator();
        int index = 0;
        while (paramIterator.hasNext()) {
            Object param = paramIterator.next();
            if (param instanceof TypeUnspecifiedSQLParameter) {
                result.setObject(index + 1, param, 1111);
            } else {
                result.setObject(index + 1, param);
            }
            ++index;
        }
        if (ConnectionMode.MEMORY_STRICTLY == connectionMode) {
            this.setFetchSize(result, databaseType);
        }
        return result;
    }

    private void setFetchSize(Statement statement, DatabaseType databaseType) throws SQLException {
        Optional fetchSizeSetter = DatabaseTypedSPILoader.findService(StatementMemoryStrictlyFetchSizeSetter.class, (DatabaseType)databaseType);
        if (fetchSizeSetter.isPresent()) {
            ((StatementMemoryStrictlyFetchSizeSetter)fetchSizeSetter.get()).setFetchSize(statement);
        }
    }
}

