/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.data;

import lombok.Generated;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnectorFactory;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.data.type.UnicastDatabaseProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.DatabaseSelectRequiredSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DoStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class DatabaseProxyBackendHandlerFactory {
    public static DatabaseProxyBackendHandler newInstance(QueryContext queryContext, ConnectionSession connectionSession, boolean preferPreparedStatement) {
        SQLStatement sqlStatement = queryContext.getSqlStatementContext().getSqlStatement();
        if (sqlStatement instanceof SetStatement && null == connectionSession.getUsedDatabaseName()) {
            return () -> new UpdateResponseHeader(sqlStatement);
        }
        if (sqlStatement instanceof DoStatement || DatabaseProxyBackendHandlerFactory.isNotDatabaseSelectRequiredDALStatement(sqlStatement) || DatabaseProxyBackendHandlerFactory.isNotContainFromSelectStatement(sqlStatement)) {
            return new UnicastDatabaseProxyBackendHandler(queryContext, ProxyContext.getInstance().getContextManager(), connectionSession);
        }
        return DatabaseProxyConnectorFactory.newInstance(queryContext, connectionSession.getDatabaseConnectionManager(), preferPreparedStatement);
    }

    private static boolean isNotDatabaseSelectRequiredDALStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof DALStatement && !sqlStatement.getAttributes().findAttribute(DatabaseSelectRequiredSQLStatementAttribute.class).isPresent();
    }

    private static boolean isNotContainFromSelectStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof SelectStatement && !((SelectStatement)sqlStatement).getFrom().isPresent();
    }

    @Generated
    private DatabaseProxyBackendHandlerFactory() {
    }
}

