/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.handshake;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.exception.FirebirdProtocolException;
import org.firebirdsql.util.ByteArrayHelper;

public final class FirebirdSRPAuthenticationData {
    private static final int SRP_KEY_SIZE = 128;
    private static final int SRP_SALT_SIZE = 32;
    private static final int EXPECTED_AUTH_DATA_LENGTH = 324;
    private static final BigInteger N = new BigInteger("E67D2E994B2F900C3F41F08F5BB2627ED0D49EE1FE767A52EFCD565CD6E768812C3E1E9CE8F0A8BEA6CB13CD29DDEBF7A96D4A93B55D488DF099A15C89DCB0640738EB2CBDD9A8F7BAB561AB1B0DC1C6CDABF303264A08D1BCA932D1F1EE428B619D970F342ABA9A65793B8B2F041AE5364350C16F735F56ECBCA87BD57B29E7", 16);
    private static final BigInteger G = new BigInteger("2");
    private static final BigInteger K = new BigInteger("1277432915985975349439481660349303019122249719989");
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final byte SEPARATOR_BYTE = 58;
    private final MessageDigest sha1Md = MessageDigest.getInstance("SHA-1");
    private final String clientProofHashAlgorithm;
    private final BigInteger clientPublicKey;
    private final BigInteger publicKey;
    private final BigInteger privateKey;
    private final byte[] salt;
    private final BigInteger verifier;
    private byte[] sessionKey;

    public FirebirdSRPAuthenticationData(String hashAlgorithm, String username, String password, String userPublicKey) {
        this.clientProofHashAlgorithm = hashAlgorithm;
        this.clientPublicKey = new BigInteger(FirebirdSRPAuthenticationData.padHexBinary(userPublicKey), 16);
        this.privateKey = FirebirdSRPAuthenticationData.generateSecret();
        this.salt = FirebirdSRPAuthenticationData.generateSalt();
        this.verifier = G.modPow(this.getUserHash(FirebirdSRPAuthenticationData.normalizeLogin(username), password, this.salt), N);
        this.publicKey = this.computePublicKey();
    }

    private static BigInteger fromBigByteArray(byte[] bytes) {
        return new BigInteger(1, bytes);
    }

    private static byte[] toBigByteArray(BigInteger n) {
        return FirebirdSRPAuthenticationData.stripLeadingZeroes(n.toByteArray());
    }

    private static byte[] stripLeadingZeroes(byte[] bytes) {
        int i;
        if (bytes[0] != 0) {
            return bytes;
        }
        for (i = 1; i < bytes.length && bytes[i] == 0; ++i) {
        }
        return Arrays.copyOfRange(bytes, i, bytes.length);
    }

    private static String padHexBinary(String hexString) {
        return hexString.length() % 2 != 0 ? '0' + hexString : hexString;
    }

    private byte[] sha1(byte[] bytes) {
        try {
            byte[] byArray = this.sha1Md.digest(bytes);
            return byArray;
        }
        finally {
            this.sha1Md.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] sha1(byte[] bytes1, byte[] bytes2) {
        try {
            this.sha1Md.update(bytes1);
            byte[] byArray = this.sha1Md.digest(bytes2);
            return byArray;
        }
        finally {
            this.sha1Md.reset();
        }
    }

    private static byte[] pad(BigInteger n) {
        byte[] byteArray = FirebirdSRPAuthenticationData.toBigByteArray(n);
        if (byteArray.length > 128) {
            return Arrays.copyOfRange(byteArray, byteArray.length - 128, byteArray.length);
        }
        return byteArray;
    }

    private BigInteger getScramble(BigInteger x, BigInteger y) {
        return FirebirdSRPAuthenticationData.fromBigByteArray(this.sha1(FirebirdSRPAuthenticationData.pad(x), FirebirdSRPAuthenticationData.pad(y)));
    }

    private static BigInteger generateSecret() {
        return new BigInteger(128, RANDOM);
    }

    private static byte[] generateSalt() {
        byte[] saltBytes = new byte[32];
        RANDOM.nextBytes(saltBytes);
        return saltBytes;
    }

    private BigInteger computePublicKey() {
        BigInteger gb = G.modPow(this.privateKey, N);
        BigInteger kv = K.multiply(this.verifier).mod(N);
        return kv.add(gb).mod(N);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigInteger getUserHash(String user, String password, byte[] salt) {
        byte[] hash1;
        try {
            this.sha1Md.update(user.getBytes(StandardCharsets.UTF_8));
            this.sha1Md.update((byte)58);
            hash1 = this.sha1Md.digest(password.getBytes(StandardCharsets.UTF_8));
        }
        finally {
            this.sha1Md.reset();
        }
        byte[] hash2 = this.sha1(salt, hash1);
        return FirebirdSRPAuthenticationData.fromBigByteArray(hash2);
    }

    private byte[] computeServerSessionKey() {
        BigInteger u = this.getScramble(this.clientPublicKey, this.publicKey);
        BigInteger vu = this.verifier.modPow(u, N);
        BigInteger avu = this.clientPublicKey.multiply(vu).mod(N);
        BigInteger sessionSecret = avu.modPow(this.privateKey, N);
        return this.sha1(FirebirdSRPAuthenticationData.toBigByteArray(sessionSecret));
    }

    public byte[] serverProof(String user) {
        byte[] serverSessionKey = this.computeServerSessionKey();
        BigInteger n1 = FirebirdSRPAuthenticationData.fromBigByteArray(this.sha1(FirebirdSRPAuthenticationData.toBigByteArray(N)));
        BigInteger n2 = FirebirdSRPAuthenticationData.fromBigByteArray(this.sha1(FirebirdSRPAuthenticationData.toBigByteArray(G)));
        byte[] clientProof = this.clientProofHash(FirebirdSRPAuthenticationData.toBigByteArray(n1.modPow(n2, N)), FirebirdSRPAuthenticationData.stripLeadingZeroes(this.sha1(FirebirdSRPAuthenticationData.normalizeLogin(user).getBytes(StandardCharsets.UTF_8))), this.salt, FirebirdSRPAuthenticationData.toBigByteArray(this.clientPublicKey), FirebirdSRPAuthenticationData.toBigByteArray(this.publicKey), serverSessionKey);
        this.sessionKey = serverSessionKey;
        return clientProof;
    }

    public String getPublicKeyHex() {
        return ByteArrayHelper.toHexString((byte[])FirebirdSRPAuthenticationData.pad(this.publicKey));
    }

    private byte[] clientProofHash(byte[] ... arrays) throws FirebirdProtocolException {
        try {
            MessageDigest md = MessageDigest.getInstance(this.clientProofHashAlgorithm);
            for (byte[] array : arrays) {
                md.update(array);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new FirebirdProtocolException("Unrecognised hash algorithm `%s`.", this.clientProofHashAlgorithm);
        }
    }

    static String normalizeLogin(String login) {
        if (login == null || login.isEmpty()) {
            return login;
        }
        if (login.length() > 2 && login.charAt(0) == '\"' && login.charAt(login.length() - 1) == '\"') {
            return FirebirdSRPAuthenticationData.normalizeQuotedLogin(login);
        }
        return login.toUpperCase(Locale.ROOT);
    }

    private static String normalizeQuotedLogin(String login) {
        StringBuilder sb = new StringBuilder(login.length() - 2);
        sb.append(login, 1, login.length() - 1);
        int idx = 0;
        while (idx < sb.length()) {
            if (sb.charAt(idx) == '\"') {
                sb.deleteCharAt(idx);
                if (idx < sb.length() && sb.charAt(idx) == '\"') {
                    ++idx;
                    continue;
                }
                sb.setLength(idx);
                return sb.toString();
            }
            ++idx;
        }
        return sb.toString();
    }

    @Generated
    public MessageDigest getSha1Md() {
        return this.sha1Md;
    }

    @Generated
    public String getClientProofHashAlgorithm() {
        return this.clientProofHashAlgorithm;
    }

    @Generated
    public BigInteger getClientPublicKey() {
        return this.clientPublicKey;
    }

    @Generated
    public BigInteger getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public byte[] getSalt() {
        return this.salt;
    }

    @Generated
    public BigInteger getVerifier() {
        return this.verifier;
    }

    @Generated
    public byte[] getSessionKey() {
        return this.sessionKey;
    }
}

