/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.plugin.jar;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.LinkedList;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

public final class PluginJarLoader {
    private static final Logger LOGGER = Logger.getLogger(PluginJarLoader.class.getName());

    public static Collection<JarFile> load(File agentRootPath) throws IOException {
        Collection<File> jarFiles = PluginJarLoader.getJarFiles(new File(String.join((CharSequence)File.separator, agentRootPath.getPath(), "plugins")));
        LinkedList<JarFile> result = new LinkedList<JarFile>();
        for (File each : jarFiles) {
            result.add(new JarFile(each, true));
            LOGGER.log(Level.INFO, "Loaded jar: {0}", new String[]{each.getName()});
        }
        return result;
    }

    private static Collection<File> getJarFiles(File file) {
        final LinkedList<File> result = new LinkedList<File>();
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) {
                File currentFile = path.toFile();
                if (currentFile.isFile() && !currentFile.isHidden() && currentFile.getName().endsWith(".jar")) {
                    result.add(currentFile);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }

    @Generated
    private PluginJarLoader() {
    }
}

