/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.route.qualified.type;

import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.readwritesplitting.route.qualified.QualifiedReadwriteSplittingDataSourceRouter;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceGroupRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class QualifiedReadwriteSplittingPrimaryDataSourceRouter
implements QualifiedReadwriteSplittingDataSourceRouter {
    @Override
    public boolean isQualified(SQLStatementContext sqlStatementContext, ReadwriteSplittingDataSourceGroupRule rule, HintValueContext hintValueContext) {
        return this.isPrimaryRoute(sqlStatementContext, hintValueContext);
    }

    private boolean isPrimaryRoute(SQLStatementContext sqlStatementContext, HintValueContext hintValueContext) {
        return this.isWriteRouteStatement(sqlStatementContext) || this.isHintWriteRouteOnly(hintValueContext);
    }

    private boolean isWriteRouteStatement(SQLStatementContext sqlStatementContext) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        return this.containsLockSegment(sqlStatement) || this.containsLastInsertIdProjection(sqlStatementContext) || !this.isSelectStatement(sqlStatement);
    }

    private boolean containsLockSegment(SQLStatement sqlStatement) {
        return sqlStatement instanceof SelectStatement && ((SelectStatement)sqlStatement).getLock().isPresent();
    }

    private boolean containsLastInsertIdProjection(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).getProjectionsContext().isContainsLastInsertIdProjection();
    }

    private boolean isSelectStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof SelectStatement;
    }

    private boolean isHintWriteRouteOnly(HintValueContext hintValueContext) {
        return HintManager.isWriteRouteOnly() || hintValueContext.isWriteRouteOnly();
    }

    @Override
    public String route(ReadwriteSplittingDataSourceGroupRule rule) {
        return rule.getWriteDataSource();
    }
}

