/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.loadbalancer.spi.LoadBalanceAlgorithm;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.expr.entry.InlineExpressionParserFactory;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttributes;
import org.apache.shardingsphere.infra.rule.scope.DatabaseRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.constant.ReadwriteSplittingDataSourceType;
import org.apache.shardingsphere.readwritesplitting.exception.ReadwriteSplittingRuleExceptionIdentifier;
import org.apache.shardingsphere.readwritesplitting.exception.actual.InvalidReadwriteSplittingActualDataSourceInlineExpressionException;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceGroupRule;
import org.apache.shardingsphere.readwritesplitting.rule.attribute.ReadwriteSplittingDataSourceMapperRuleAttribute;
import org.apache.shardingsphere.readwritesplitting.rule.attribute.ReadwriteSplittingExportableRuleAttribute;
import org.apache.shardingsphere.readwritesplitting.rule.attribute.ReadwriteSplittingStaticDataSourceRuleAttribute;
import org.apache.shardingsphere.readwritesplitting.rule.attribute.ReadwriteSplittingStorageConnectorReusableRuleAttribute;

public final class ReadwriteSplittingRule
implements DatabaseRule {
    private final ReadwriteSplittingRuleConfiguration configuration;
    private final Map<String, LoadBalanceAlgorithm> loadBalancers;
    private final Map<String, ReadwriteSplittingDataSourceGroupRule> dataSourceRuleGroups;
    private final RuleAttributes attributes;

    public ReadwriteSplittingRule(String databaseName, ReadwriteSplittingRuleConfiguration ruleConfig, ComputeNodeInstanceContext computeNodeInstanceContext) {
        this.configuration = ruleConfig;
        this.loadBalancers = this.createLoadBalancers(ruleConfig);
        this.dataSourceRuleGroups = this.createDataSourceGroupRules(databaseName, ruleConfig);
        this.attributes = new RuleAttributes(new RuleAttribute[]{new ReadwriteSplittingDataSourceMapperRuleAttribute(this.dataSourceRuleGroups.values()), new ReadwriteSplittingStaticDataSourceRuleAttribute(databaseName, this.dataSourceRuleGroups, computeNodeInstanceContext), new ReadwriteSplittingExportableRuleAttribute(this.dataSourceRuleGroups), new ReadwriteSplittingStorageConnectorReusableRuleAttribute()});
    }

    private Map<String, LoadBalanceAlgorithm> createLoadBalancers(ReadwriteSplittingRuleConfiguration ruleConfig) {
        HashMap<String, LoadBalanceAlgorithm> result = new HashMap<String, LoadBalanceAlgorithm>(ruleConfig.getDataSourceGroups().size(), 1.0f);
        for (ReadwriteSplittingDataSourceGroupRuleConfiguration each : ruleConfig.getDataSourceGroups()) {
            if (!ruleConfig.getLoadBalancers().containsKey(each.getLoadBalancerName())) continue;
            AlgorithmConfiguration algorithmConfig = (AlgorithmConfiguration)ruleConfig.getLoadBalancers().get(each.getLoadBalancerName());
            result.put(each.getName() + "." + each.getLoadBalancerName(), (LoadBalanceAlgorithm)TypedSPILoader.getService(LoadBalanceAlgorithm.class, (Object)algorithmConfig.getType(), (Properties)algorithmConfig.getProps()));
        }
        return result;
    }

    private Map<String, ReadwriteSplittingDataSourceGroupRule> createDataSourceGroupRules(String databaseName, ReadwriteSplittingRuleConfiguration ruleConfig) {
        HashMap<String, ReadwriteSplittingDataSourceGroupRule> result = new HashMap<String, ReadwriteSplittingDataSourceGroupRule>(ruleConfig.getDataSourceGroups().size(), 1.0f);
        for (ReadwriteSplittingDataSourceGroupRuleConfiguration each : ruleConfig.getDataSourceGroups()) {
            result.putAll(this.createDataSourceGroupRules(databaseName, each));
        }
        return result;
    }

    private Map<String, ReadwriteSplittingDataSourceGroupRule> createDataSourceGroupRules(String databaseName, ReadwriteSplittingDataSourceGroupRuleConfiguration config) {
        LoadBalanceAlgorithm loadBalanceAlgorithm = this.loadBalancers.getOrDefault(config.getName() + "." + config.getLoadBalancerName(), (LoadBalanceAlgorithm)TypedSPILoader.getService(LoadBalanceAlgorithm.class, null));
        return this.createStaticDataSourceGroupRules(databaseName, config, loadBalanceAlgorithm);
    }

    private Map<String, ReadwriteSplittingDataSourceGroupRule> createStaticDataSourceGroupRules(String databaseName, ReadwriteSplittingDataSourceGroupRuleConfiguration config, LoadBalanceAlgorithm loadBalanceAlgorithm) {
        List inlineLogicDataSourceNames = InlineExpressionParserFactory.newInstance((String)config.getName()).splitAndEvaluate();
        List inlineWriteDataSourceNames = InlineExpressionParserFactory.newInstance((String)config.getWriteDataSourceName()).splitAndEvaluate();
        List<List<String>> inlineReadDataSourceNames = config.getReadDataSourceNames().stream().map(each -> InlineExpressionParserFactory.newInstance((String)each).splitAndEvaluate()).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((inlineWriteDataSourceNames.size() == inlineLogicDataSourceNames.size() ? 1 : 0) != 0, () -> new InvalidReadwriteSplittingActualDataSourceInlineExpressionException(ReadwriteSplittingDataSourceType.WRITE, new ReadwriteSplittingRuleExceptionIdentifier(databaseName, config.getName())));
        inlineReadDataSourceNames.forEach(each -> ShardingSpherePreconditions.checkState((each.size() == inlineLogicDataSourceNames.size() ? 1 : 0) != 0, () -> new InvalidReadwriteSplittingActualDataSourceInlineExpressionException(ReadwriteSplittingDataSourceType.READ, new ReadwriteSplittingRuleExceptionIdentifier(databaseName, config.getName()))));
        HashMap<String, ReadwriteSplittingDataSourceGroupRule> result = new HashMap<String, ReadwriteSplittingDataSourceGroupRule>(inlineLogicDataSourceNames.size(), 1.0f);
        for (int i = 0; i < inlineLogicDataSourceNames.size(); ++i) {
            ReadwriteSplittingDataSourceGroupRuleConfiguration staticConfig = this.createStaticDataSourceGroupRuleConfiguration(config, i, inlineLogicDataSourceNames, inlineWriteDataSourceNames, inlineReadDataSourceNames);
            result.put((String)inlineLogicDataSourceNames.get(i), new ReadwriteSplittingDataSourceGroupRule(staticConfig, config.getTransactionalReadQueryStrategy(), loadBalanceAlgorithm));
        }
        return result;
    }

    private ReadwriteSplittingDataSourceGroupRuleConfiguration createStaticDataSourceGroupRuleConfiguration(ReadwriteSplittingDataSourceGroupRuleConfiguration config, int index, List<String> logicDataSourceNames, List<String> writeDatasourceNames, List<List<String>> readDatasourceNames) {
        List readDataSourceNames = readDatasourceNames.stream().map(each -> (String)each.get(index)).collect(Collectors.toList());
        return new ReadwriteSplittingDataSourceGroupRuleConfiguration(logicDataSourceNames.get(index), writeDatasourceNames.get(index), readDataSourceNames, config.getLoadBalancerName());
    }

    public ReadwriteSplittingDataSourceGroupRule getSingleDataSourceGroupRule() {
        return this.dataSourceRuleGroups.values().iterator().next();
    }

    public Optional<ReadwriteSplittingDataSourceGroupRule> findDataSourceGroupRule(String dataSourceName) {
        return Optional.ofNullable(this.dataSourceRuleGroups.get(dataSourceName));
    }

    public int getOrder() {
        return 45;
    }

    @Generated
    public ReadwriteSplittingRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Map<String, ReadwriteSplittingDataSourceGroupRule> getDataSourceRuleGroups() {
        return this.dataSourceRuleGroups;
    }

    @Generated
    public RuleAttributes getAttributes() {
        return this.attributes;
    }
}

