/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.exception.mysql.exception.UnknownSystemVariableException;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnector;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnectorFactory;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminUpdateExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset.CharsetSetExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.session.SessionVariableRecordExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar.MySQLSystemVariable;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar.MySQLSystemVariableScope;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;

public final class MySQLSetVariableAdminExecutor
implements DatabaseAdminUpdateExecutor {
    private final SetStatement sqlStatement;

    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) throws SQLException {
        Map<String, String> sessionVariables = this.extractSessionVariables();
        this.validateSessionVariables(sessionVariables.keySet());
        CharsetSetExecutor charsetSetExecutor = new CharsetSetExecutor(this.sqlStatement.getDatabaseType(), connectionSession);
        sessionVariables.forEach((arg_0, arg_1) -> ((CharsetSetExecutor)charsetSetExecutor).set(arg_0, arg_1));
        new SessionVariableRecordExecutor(this.sqlStatement.getDatabaseType(), connectionSession).recordVariable(sessionVariables);
        this.executeSetGlobalVariablesIfPresent(connectionSession, metaData);
    }

    private Map<String, String> extractSessionVariables() {
        return this.sqlStatement.getVariableAssigns().stream().filter(each -> !"global".equalsIgnoreCase(each.getVariable().getScope().orElse(""))).collect(Collectors.toMap(each -> each.getVariable().getVariable(), VariableAssignSegment::getAssignValue));
    }

    private void validateSessionVariables(Collection<String> sessionVariables) {
        for (String each : sessionVariables) {
            MySQLSystemVariable systemVariable = MySQLSystemVariable.findSystemVariable(each).orElseThrow(() -> new UnknownSystemVariableException(each));
            systemVariable.validateSetTargetScope(MySQLSystemVariableScope.SESSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSetGlobalVariablesIfPresent(ConnectionSession connectionSession, ShardingSphereMetaData metaData) throws SQLException {
        if (null == connectionSession.getUsedDatabaseName()) {
            return;
        }
        String concatenatedGlobalVariables = this.extractGlobalVariables().entrySet().stream().map(entry -> String.format("@@GLOBAL.%s = %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        if (concatenatedGlobalVariables.isEmpty()) {
            return;
        }
        String sql = "SET " + concatenatedGlobalVariables;
        SQLParserRule sqlParserRule = (SQLParserRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        SQLStatement sqlStatement = sqlParserRule.getSQLParserEngine(this.sqlStatement.getDatabaseType()).parse(sql, false);
        SQLStatementContext sqlStatementContext = new SQLBindEngine(metaData, connectionSession.getCurrentDatabaseName(), new HintValueContext()).bind(sqlStatement);
        try (DatabaseProxyConnector databaseProxyBackendHandler = DatabaseProxyConnectorFactory.newInstance((QueryContext)new QueryContext(sqlStatementContext, sql, Collections.emptyList(), new HintValueContext(), connectionSession.getConnectionContext(), metaData), (ProxyDatabaseConnectionManager)connectionSession.getDatabaseConnectionManager(), (boolean)false);){
            databaseProxyBackendHandler.execute();
        }
    }

    private Map<String, String> extractGlobalVariables() {
        return this.sqlStatement.getVariableAssigns().stream().filter(each -> "global".equalsIgnoreCase(each.getVariable().getScope().orElse(""))).collect(Collectors.toMap(each -> each.getVariable().getVariable(), VariableAssignSegment::getAssignValue, (oldValue, newValue) -> newValue, LinkedHashMap::new));
    }

    @Generated
    public MySQLSetVariableAdminExecutor(SetStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }
}

