/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.collector.postgresql;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.statistics.collector.DialectDatabaseStatisticsCollector;
import org.apache.shardingsphere.infra.metadata.statistics.collector.postgresql.PostgreSQLTableStatisticsCollector;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class PostgreSQLStatisticsCollector
implements DialectDatabaseStatisticsCollector {
    private static final Map<String, Collection<String>> STATISTICS_SCHEMA_TABLES = new CaseInsensitiveMap();

    @Override
    public Optional<Collection<Map<String, Object>>> collectRowColumnValues(String databaseName, String schemaName, String tableName, ShardingSphereMetaData metaData) {
        return TypedSPILoader.findService(PostgreSQLTableStatisticsCollector.class, (Object)String.format("%s.%s", schemaName, tableName)).map(optional -> optional.collect(databaseName, schemaName, tableName, metaData));
    }

    @Override
    public boolean isStatisticsTables(Map<String, Collection<String>> schemaTables) {
        if (schemaTables.isEmpty()) {
            return false;
        }
        return schemaTables.entrySet().stream().allMatch(entry -> this.isStatisticsTables((String)entry.getKey(), (Collection)entry.getValue()));
    }

    private boolean isStatisticsTables(String schemaName, Collection<String> tableNames) {
        return STATISTICS_SCHEMA_TABLES.containsKey(schemaName) && STATISTICS_SCHEMA_TABLES.get(schemaName).containsAll(tableNames);
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }

    static {
        for (PostgreSQLTableStatisticsCollector each : ShardingSphereServiceLoader.getServiceInstances(PostgreSQLTableStatisticsCollector.class)) {
            if (!STATISTICS_SCHEMA_TABLES.containsKey(each.getSchemaName())) {
                STATISTICS_SCHEMA_TABLES.put(each.getSchemaName(), (Collection<String>)new CaseInsensitiveSet());
            }
            STATISTICS_SCHEMA_TABLES.get(each.getSchemaName()).add(each.getTableName());
        }
    }
}

