/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.executor.rdl.resource;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.statement.type.rdl.resource.unit.type.UnregisterStorageUnitStatement;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.external.server.ShardingSphereServerException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.InUsedStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.StorageUnitsOperateException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.resoure.UnregisterStorageUnitRuleAttribute;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class UnregisterStorageUnitExecutor
implements DistSQLUpdateExecutor<UnregisterStorageUnitStatement>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;

    @Override
    public void executeUpdate(UnregisterStorageUnitStatement sqlStatement, ContextManager contextManager) {
        if (!sqlStatement.isIfExists()) {
            this.checkExisted(sqlStatement.getStorageUnitNames());
        }
        this.checkInUsed(sqlStatement);
        try {
            contextManager.getPersistServiceFacade().getModeFacade().getMetaDataManagerService().unregisterStorageUnits(this.database, sqlStatement.getStorageUnitNames());
        }
        catch (ShardingSphereServerException ex) {
            throw new StorageUnitsOperateException("unregister", sqlStatement.getStorageUnitNames(), (Exception)((Object)ex));
        }
    }

    private void checkExisted(Collection<String> storageUnitNames) {
        Map storageUnits = this.database.getResourceMetaData().getStorageUnits();
        Collection notExistedStorageUnits = storageUnitNames.stream().filter(each -> !storageUnits.containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedStorageUnits, () -> new MissingRequiredStorageUnitsException(this.database.getName(), notExistedStorageUnits));
    }

    private void checkInUsed(UnregisterStorageUnitStatement sqlStatement) {
        Map inUsedStorageUnits = this.database.getRuleMetaData().getInUsedStorageUnitNameAndRulesMap();
        Set inUsedStorageUnitNames = inUsedStorageUnits.keySet();
        inUsedStorageUnitNames.retainAll(sqlStatement.getStorageUnitNames());
        if (inUsedStorageUnitNames.isEmpty()) {
            return;
        }
        Collection<Class<? extends ShardingSphereRule>> ignoreUsageCheckRules = this.getIgnoreUsageCheckRules(sqlStatement);
        String firstResource = (String)inUsedStorageUnitNames.iterator().next();
        ShardingSpherePreconditions.checkNotEmpty(ignoreUsageCheckRules, () -> new InUsedStorageUnitException(firstResource, (Collection)inUsedStorageUnits.get(firstResource)));
        this.checkInUsedIgnoreTables(new HashSet<String>(inUsedStorageUnitNames), inUsedStorageUnits, ignoreUsageCheckRules);
    }

    private Collection<Class<? extends ShardingSphereRule>> getIgnoreUsageCheckRules(UnregisterStorageUnitStatement sqlStatement) {
        LinkedList<Class<? extends ShardingSphereRule>> result = new LinkedList<Class<? extends ShardingSphereRule>>();
        for (ShardingSphereRule each : this.database.getRuleMetaData().getRules()) {
            Optional ruleAttribute = each.getAttributes().findAttribute(UnregisterStorageUnitRuleAttribute.class);
            if (!ruleAttribute.isPresent() || !((UnregisterStorageUnitRuleAttribute)ruleAttribute.get()).ignoreUsageCheck(sqlStatement.isIgnoreSingleTables(), sqlStatement.isIgnoreBroadcastTables())) continue;
            result.add(each.getClass());
        }
        return result;
    }

    private void checkInUsedIgnoreTables(Collection<String> inUsedResourceNames, Map<String, Collection<Class<? extends ShardingSphereRule>>> inUsedStorageUnits, Collection<Class<? extends ShardingSphereRule>> ignoreShardingSphereRules) {
        for (String each : inUsedResourceNames) {
            Collection<Class<? extends ShardingSphereRule>> inUsedRules = inUsedStorageUnits.get(each);
            ignoreShardingSphereRules.forEach(inUsedRules::remove);
            ShardingSpherePreconditions.checkMustEmpty(inUsedRules, () -> new InUsedStorageUnitException(each, inUsedRules));
        }
    }

    @Override
    public Class<UnregisterStorageUnitStatement> getType() {
        return UnregisterStorageUnitStatement.class;
    }

    @Override
    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

