/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataConsistencyCheckUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataConsistencyCheckUtils.class);

    public static boolean recordsEquals(Map<String, Object> thisRecord, Map<String, Object> thatRecord, EqualsBuilder equalsBuilder) {
        Iterator<Map.Entry<String, Object>> thisRecordIterator = thisRecord.entrySet().iterator();
        Iterator<Map.Entry<String, Object>> thatRecordIterator = thatRecord.entrySet().iterator();
        int columnIndex = 0;
        while (thisRecordIterator.hasNext() && thatRecordIterator.hasNext()) {
            Object thatColumnValue;
            ++columnIndex;
            Object thisColumnValue = thisRecordIterator.next().getValue();
            if (DataConsistencyCheckUtils.isMatched(equalsBuilder, thisColumnValue, thatColumnValue = thatRecordIterator.next().getValue())) continue;
            log.warn("Record column value not match, columnIndex={}, value1={}, value2={}, value1.class={}, value2.class={}.", new Object[]{columnIndex, thisColumnValue, thatColumnValue, null != thisColumnValue ? thisColumnValue.getClass().getName() : "", null == thatColumnValue ? "" : thatColumnValue.getClass().getName()});
            return false;
        }
        return true;
    }

    public static boolean isFirstUniqueKeyValueMatched(Map<String, Object> thisRecord, Map<String, Object> thatRecord, String uniqueKey, EqualsBuilder equalsBuilder) {
        if (thisRecord.isEmpty() || thatRecord.isEmpty()) {
            return false;
        }
        return DataConsistencyCheckUtils.isMatched(equalsBuilder, DataConsistencyCheckUtils.getFirstUniqueKeyValue(thisRecord, uniqueKey), DataConsistencyCheckUtils.getFirstUniqueKeyValue(thatRecord, uniqueKey));
    }

    public static boolean isMatched(EqualsBuilder equalsBuilder, Object thisColumnValue, Object thatColumnValue) {
        equalsBuilder.reset();
        if (thisColumnValue instanceof Number && thatColumnValue instanceof Number) {
            return DataConsistencyCheckUtils.isNumberEquals((Number)thisColumnValue, (Number)thatColumnValue);
        }
        if (thisColumnValue instanceof SQLXML && thatColumnValue instanceof SQLXML) {
            return ((SQLXML)thisColumnValue).getString().equals(((SQLXML)thatColumnValue).getString());
        }
        if (thisColumnValue instanceof Timestamp && thatColumnValue instanceof Timestamp) {
            return ((Timestamp)thisColumnValue).getTime() / 1000L * 1000L == ((Timestamp)thatColumnValue).getTime() / 1000L * 1000L;
        }
        if (thisColumnValue instanceof Array && thatColumnValue instanceof Array) {
            return Objects.deepEquals(((Array)thisColumnValue).getArray(), ((Array)thatColumnValue).getArray());
        }
        return equalsBuilder.append(thisColumnValue, thatColumnValue).isEquals();
    }

    private static boolean isNumberEquals(Number one, Number another) {
        if (DataConsistencyCheckUtils.isInteger(one) && DataConsistencyCheckUtils.isInteger(another)) {
            return one.longValue() == another.longValue();
        }
        return DataConsistencyCheckUtils.isBigDecimalEquals(DataConsistencyCheckUtils.convertToBigDecimal(one), DataConsistencyCheckUtils.convertToBigDecimal(another));
    }

    private static boolean isInteger(Number value) {
        return value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte;
    }

    public static BigDecimal convertToBigDecimal(Number value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (DataConsistencyCheckUtils.isInteger(value)) {
            return BigDecimal.valueOf(value.longValue());
        }
        if (value instanceof Float || value instanceof Double) {
            return BigDecimal.valueOf(value.doubleValue());
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        return new BigDecimal(value.toString());
    }

    public static boolean isBigDecimalEquals(BigDecimal one, BigDecimal another) {
        BigDecimal decimalTwo;
        BigDecimal decimalOne;
        if (one.scale() == another.scale()) {
            decimalOne = one;
            decimalTwo = another;
        } else if (one.scale() > another.scale()) {
            decimalOne = one;
            decimalTwo = another.setScale(one.scale(), RoundingMode.UNNECESSARY);
        } else {
            decimalOne = one.setScale(another.scale(), RoundingMode.UNNECESSARY);
            decimalTwo = another;
        }
        return 0 == decimalOne.compareTo(decimalTwo);
    }

    public static boolean compareLists(@Nullable Collection<?> thisList, @Nullable Collection<?> thatList) {
        if (null == thisList && null == thatList) {
            return true;
        }
        if (null == thisList || null == thatList) {
            return false;
        }
        if (thisList.size() != thatList.size()) {
            return false;
        }
        Iterator<?> thisIterator = thisList.iterator();
        Iterator<?> thatIterator = thatList.iterator();
        while (thisIterator.hasNext() && thatIterator.hasNext()) {
            if (Objects.deepEquals(thisIterator.next(), thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    public static Object getFirstUniqueKeyValue(Map<String, Object> record, @Nullable String uniqueKey) {
        return record.isEmpty() || null == uniqueKey ? null : record.get(uniqueKey);
    }

    @Generated
    private DataConsistencyCheckUtils() {
    }
}

