/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.registrycenter.elasticjob.CoordinatorRegistryCenterInitializer;
import org.apache.shardingsphere.data.pipeline.core.registrycenter.repository.PipelineGovernanceFacade;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobConfigurationAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobOperateAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobStatisticsAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.ShardingStatisticsAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.operate.JobOperateAPIImpl;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.settings.JobConfigurationAPIImpl;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.statistics.JobStatisticsAPIImpl;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.statistics.ShardingStatisticsAPIImpl;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class PipelineAPIFactory {
    private static final Map<PipelineContextKey, LazyInitializer<PipelineGovernanceFacade>> GOVERNANCE_FACADE_MAP = new ConcurrentHashMap<PipelineContextKey, LazyInitializer<PipelineGovernanceFacade>>();

    public static PipelineGovernanceFacade getPipelineGovernanceFacade(final PipelineContextKey contextKey) {
        return (PipelineGovernanceFacade)GOVERNANCE_FACADE_MAP.computeIfAbsent(contextKey, key -> new LazyInitializer<PipelineGovernanceFacade>(){

            protected PipelineGovernanceFacade initialize() {
                return new PipelineGovernanceFacade((ClusterPersistRepository)PipelineContextManager.getContext(contextKey).getPersistServiceFacade().getRepository());
            }
        }).get();
    }

    public static JobStatisticsAPI getJobStatisticsAPI(PipelineContextKey contextKey) {
        return ElasticJobAPIHolder.getInstance(contextKey).jobStatisticsAPI;
    }

    public static JobConfigurationAPI getJobConfigurationAPI(PipelineContextKey contextKey) {
        return ElasticJobAPIHolder.getInstance(contextKey).jobConfigurationAPI;
    }

    public static JobOperateAPI getJobOperateAPI(PipelineContextKey contextKey) {
        return ElasticJobAPIHolder.getInstance(contextKey).jobOperateAPI;
    }

    public static ShardingStatisticsAPI getShardingStatisticsAPI(PipelineContextKey contextKey) {
        return ElasticJobAPIHolder.getInstance(contextKey).shardingStatisticsAPI;
    }

    public static CoordinatorRegistryCenter getRegistryCenter(PipelineContextKey contextKey) {
        return RegistryCenterHolder.getInstance(contextKey).registryCenter;
    }

    @Generated
    private PipelineAPIFactory() {
    }

    private static final class ElasticJobAPIHolder {
        private static final Map<PipelineContextKey, ElasticJobAPIHolder> INSTANCE_MAP = new ConcurrentHashMap<PipelineContextKey, ElasticJobAPIHolder>();
        private final JobStatisticsAPI jobStatisticsAPI;
        private final JobConfigurationAPI jobConfigurationAPI;
        private final JobOperateAPI jobOperateAPI;
        private final ShardingStatisticsAPI shardingStatisticsAPI;

        private ElasticJobAPIHolder(PipelineContextKey contextKey) {
            CoordinatorRegistryCenter registryCenter = PipelineAPIFactory.getRegistryCenter(contextKey);
            this.jobStatisticsAPI = new JobStatisticsAPIImpl(registryCenter);
            this.jobConfigurationAPI = new JobConfigurationAPIImpl(registryCenter);
            this.jobOperateAPI = new JobOperateAPIImpl(registryCenter);
            this.shardingStatisticsAPI = new ShardingStatisticsAPIImpl(registryCenter);
        }

        public static ElasticJobAPIHolder getInstance(PipelineContextKey contextKey) {
            return INSTANCE_MAP.computeIfAbsent(contextKey, key -> new ElasticJobAPIHolder(contextKey));
        }
    }

    private static final class RegistryCenterHolder {
        private static final Map<PipelineContextKey, RegistryCenterHolder> INSTANCE_MAP = new ConcurrentHashMap<PipelineContextKey, RegistryCenterHolder>();
        private final CoordinatorRegistryCenter registryCenter;

        private RegistryCenterHolder(PipelineContextKey contextKey) {
            this.registryCenter = this.createRegistryCenter(contextKey);
        }

        private CoordinatorRegistryCenter createRegistryCenter(PipelineContextKey contextKey) {
            CoordinatorRegistryCenterInitializer registryCenterInitializer = new CoordinatorRegistryCenterInitializer();
            ModeConfiguration modeConfig = PipelineContextManager.getContext(contextKey).getComputeNodeInstanceContext().getModeConfiguration();
            String elasticJobNamespace = PipelineMetaDataNode.getElasticJobNamespace();
            String clusterType = modeConfig.getRepository().getType();
            ShardingSpherePreconditions.checkState((boolean)"ZooKeeper".equals(clusterType), () -> new IllegalArgumentException("Unsupported cluster type: " + clusterType));
            return registryCenterInitializer.createZookeeperRegistryCenter(modeConfig, elasticJobNamespace);
        }

        public static RegistryCenterHolder getInstance(PipelineContextKey contextKey) {
            return INSTANCE_MAP.computeIfAbsent(contextKey, key -> new RegistryCenterHolder(contextKey));
        }
    }
}

