/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.service;

import java.time.LocalDateTime;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.config.yaml.swapper.YamlPipelineJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobOption;
import org.apache.shardingsphere.data.pipeline.core.listener.PipelineElasticJobListener;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;

public final class PipelineJobConfigurationManager {
    private final PipelineJobOption jobOption;

    public <T extends PipelineJobConfiguration> T getJobConfiguration(String jobId) {
        return (T)this.jobOption.getYamlJobConfigurationSwapper().swapToObject(PipelineJobIdUtils.getElasticJobConfigurationPOJO(jobId).getJobParameter());
    }

    public JobConfigurationPOJO convertToJobConfigurationPOJO(PipelineJobConfiguration jobConfig) {
        JobConfigurationPOJO result = new JobConfigurationPOJO();
        result.setJobName(jobConfig.getJobId());
        result.setShardingTotalCount(this.jobOption.isForceNoShardingWhenConvertToJobConfigurationPOJO() ? 1 : jobConfig.getJobShardingCount());
        YamlPipelineJobConfigurationSwapper<?, ?> swapper = this.jobOption.getYamlJobConfigurationSwapper();
        result.setJobParameter(YamlEngine.marshal((Object)swapper.swapToYamlConfiguration(jobConfig)));
        String createTimeFormat = LocalDateTime.now().format(DateTimeFormatterFactory.getDatetimeFormatter());
        result.getProps().setProperty("create_time", createTimeFormat);
        result.getProps().setProperty("start_time_millis", String.valueOf(System.currentTimeMillis()));
        result.getProps().setProperty("run_count", "1");
        result.setJobListenerTypes(Collections.singletonList(PipelineElasticJobListener.class.getName()));
        result.setJobExecutorServiceHandlerType("SHARDING_TOTAL_COUNT");
        return result;
    }

    @Generated
    public PipelineJobConfigurationManager(PipelineJobOption jobOption) {
        this.jobOption = jobOption;
    }
}

