/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.loader;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.exception.job.TableNotFoundWhenSplitPipelineJobByRangeException;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineIndexMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;

public final class PipelineTableMetaDataUtils {
    public static List<PipelineColumnMetaData> getUniqueKeyColumns(String schemaName, String tableName, PipelineTableMetaDataLoader metaDataLoader) {
        PipelineTableMetaData tableMetaData = metaDataLoader.getTableMetaData(schemaName, tableName);
        ShardingSpherePreconditions.checkNotNull((Object)tableMetaData, () -> new TableNotFoundWhenSplitPipelineJobByRangeException(tableName));
        return PipelineTableMetaDataUtils.getUniqueKeyColumns(tableMetaData);
    }

    private static List<PipelineColumnMetaData> getUniqueKeyColumns(PipelineTableMetaData tableMetaData) {
        List<String> primaryKeys = tableMetaData.getPrimaryKeyColumns();
        if (!primaryKeys.isEmpty()) {
            return primaryKeys.stream().map(tableMetaData::getColumnMetaData).collect(Collectors.toList());
        }
        for (PipelineIndexMetaData each : tableMetaData.getUniqueIndexes()) {
            if (each.getColumns().get(0).isNullable()) continue;
            return each.getColumns();
        }
        return new LinkedList<PipelineColumnMetaData>();
    }

    @Generated
    private PipelineTableMetaDataUtils() {
    }
}

