/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.node;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.event.handler.PipelineMetaDataChangedEventHandler;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineMetaDataNodeWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineMetaDataNodeWatcher.class);
    private static final Map<PipelineContextKey, PipelineMetaDataNodeWatcher> INSTANCE_MAP = new ConcurrentHashMap<PipelineContextKey, PipelineMetaDataNodeWatcher>();
    private static final ExecutorService EVENT_LISTENER_EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Pipeline-EventListener-%d").build());
    private final Map<Pattern, PipelineMetaDataChangedEventHandler> listenerMap = new ConcurrentHashMap<Pattern, PipelineMetaDataChangedEventHandler>();

    private PipelineMetaDataNodeWatcher(PipelineContextKey contextKey) {
        this.listenerMap.putAll(ShardingSphereServiceLoader.getServiceInstances(PipelineMetaDataChangedEventHandler.class).stream().collect(Collectors.toMap(PipelineMetaDataChangedEventHandler::getKeyPattern, each -> each)));
        PipelineAPIFactory.getPipelineGovernanceFacade(contextKey).watchPipeLineRootPath(this::dispatchEvent);
    }

    private void dispatchEvent(DataChangedEvent event) {
        CompletableFuture.runAsync(() -> this.dispatchEvent0(event), EVENT_LISTENER_EXECUTOR).whenComplete((unused, throwable) -> {
            if (null != throwable) {
                log.error("dispatch event failed", throwable);
            }
        });
    }

    private void dispatchEvent0(DataChangedEvent event) {
        for (Map.Entry<Pattern, PipelineMetaDataChangedEventHandler> entry : this.listenerMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(event.getKey());
            if (!matcher.matches()) continue;
            String jobId = matcher.group(1);
            entry.getValue().handle(jobId, event);
            return;
        }
    }

    public static void init(PipelineContextKey contextKey) {
        INSTANCE_MAP.computeIfAbsent(contextKey, PipelineMetaDataNodeWatcher::new);
    }
}

