/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.execute;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.protocol.binary.BinaryCell;
import org.apache.shardingsphere.database.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.database.protocol.binary.BinaryRow;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLCharacterSets;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLNewParametersBoundFlag;
import org.apache.shardingsphere.database.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.MySQLBinaryResultSetRowPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.MySQLComStmtExecutePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.context.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.ServerStatusFlagCalculator;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.MySQLServerPreparedStatement;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.builder.ResponsePacketBuilder;

public final class MySQLComStmtExecuteExecutor
implements QueryCommandExecutor {
    private final MySQLComStmtExecutePacket packet;
    private final ConnectionSession connectionSession;
    private ProxyBackendHandler proxyBackendHandler;
    private ResponseType responseType;

    public Collection<DatabasePacket> execute() throws SQLException {
        MySQLServerPreparedStatement preparedStatement = this.updateAndGetPreparedStatement();
        List params = this.packet.readParameters(preparedStatement.getParameterTypes(), preparedStatement.getLongData().keySet(), preparedStatement.getParameterColumnDefinitionFlags(), preparedStatement.getParameterColumnTypes());
        preparedStatement.getLongData().forEach(params::set);
        SQLStatementContext sqlStatementContext = preparedStatement.getSqlStatementContext();
        if (sqlStatementContext instanceof ParameterAware) {
            ((ParameterAware)sqlStatementContext).bindParameters(params);
        }
        QueryContext queryContext = new QueryContext(sqlStatementContext, preparedStatement.getSql(), params, preparedStatement.getHintValueContext(), this.connectionSession.getConnectionContext(), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(), true);
        this.proxyBackendHandler = ProxyBackendHandlerFactory.newInstance((DatabaseType)((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL")), (QueryContext)queryContext, (ConnectionSession)this.connectionSession, (boolean)true);
        ResponseHeader responseHeader = this.proxyBackendHandler.execute();
        return responseHeader instanceof QueryResponseHeader ? this.processQuery((QueryResponseHeader)responseHeader) : this.processUpdate((UpdateResponseHeader)responseHeader);
    }

    private MySQLServerPreparedStatement updateAndGetPreparedStatement() {
        MySQLServerPreparedStatement result = (MySQLServerPreparedStatement)this.connectionSession.getServerPreparedStatementRegistry().getPreparedStatement((Object)this.packet.getStatementId());
        if (MySQLNewParametersBoundFlag.PARAMETER_TYPE_EXIST == this.packet.getNewParametersBoundFlag()) {
            result.getParameterTypes().clear();
            result.getParameterTypes().addAll(this.packet.getNewParameterTypes());
        }
        return result;
    }

    private Collection<DatabasePacket> processQuery(QueryResponseHeader queryResponseHeader) {
        this.responseType = ResponseType.QUERY;
        int characterSet = ((MySQLCharacterSets)this.connectionSession.getAttributeMap().attr(MySQLConstants.CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
        return ResponsePacketBuilder.buildQueryResponsePackets(queryResponseHeader, characterSet, ServerStatusFlagCalculator.calculateFor(this.connectionSession, true));
    }

    private Collection<DatabasePacket> processUpdate(UpdateResponseHeader updateResponseHeader) {
        this.responseType = ResponseType.UPDATE;
        return ResponsePacketBuilder.buildUpdateResponsePackets(updateResponseHeader, ServerStatusFlagCalculator.calculateFor(this.connectionSession, true));
    }

    public boolean next() throws SQLException {
        return this.proxyBackendHandler.next();
    }

    public MySQLPacket getQueryRowPacket() throws SQLException {
        QueryResponseRow queryResponseRow = this.proxyBackendHandler.getRowData();
        return new MySQLBinaryResultSetRowPacket(this.createBinaryRow(queryResponseRow));
    }

    private BinaryRow createBinaryRow(QueryResponseRow queryResponseRow) {
        ArrayList<BinaryCell> result = new ArrayList<BinaryCell>(queryResponseRow.getCells().size());
        for (QueryResponseCell each : queryResponseRow.getCells()) {
            result.add(new BinaryCell((BinaryColumnType)MySQLBinaryColumnType.valueOfJDBCType((int)each.getJdbcType()), each.getData()));
        }
        return new BinaryRow(result);
    }

    public void close() throws SQLException {
        if (null != this.proxyBackendHandler) {
            this.proxyBackendHandler.close();
        }
    }

    @Generated
    public MySQLComStmtExecuteExecutor(MySQLComStmtExecutePacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }

    @Generated
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

