/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.protocol;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class FrontDatabaseProtocolTypeFactory {
    private static final String DEFAULT_FRONTEND_DATABASE_PROTOCOL_TYPE = "MySQL";

    public static DatabaseType getDatabaseType() {
        Optional<DatabaseType> configuredDatabaseType = FrontDatabaseProtocolTypeFactory.findConfiguredDatabaseType();
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        Collection databaseProtocolFrontendEngines = ShardingSphereServiceLoader.getServiceInstances(DatabaseProtocolFrontendEngine.class);
        ShardingSpherePreconditions.checkNotEmpty((Collection)databaseProtocolFrontendEngines, () -> new IllegalArgumentException(String.format("Can not find any SPI implementation of `%s`.", DatabaseProtocolFrontendEngine.class.getName())));
        DatabaseType defaultDatabaseType = 1 == databaseProtocolFrontendEngines.size() ? ((DatabaseProtocolFrontendEngine)databaseProtocolFrontendEngines.iterator().next()).getType() : (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)DEFAULT_FRONTEND_DATABASE_PROTOCOL_TYPE);
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        if (metaDataContexts.getMetaData().getAllDatabases().isEmpty()) {
            return defaultDatabaseType;
        }
        Optional<ShardingSphereDatabase> database = metaDataContexts.getMetaData().getAllDatabases().stream().filter(ShardingSphereDatabase::containsDataSource).findFirst();
        return database.isPresent() ? ((StorageUnit)database.get().getResourceMetaData().getStorageUnits().values().iterator().next()).getStorageType() : defaultDatabaseType;
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType() {
        DatabaseType configuredDatabaseType = (DatabaseType)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return Optional.ofNullable(configuredDatabaseType);
    }

    @Generated
    private FrontDatabaseProtocolTypeFactory() {
    }
}

