/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.checker;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.checker.SupportedSQLCheckersBuilder;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class SupportedSQLCheckEngine {
    public void checkSQL(Collection<ShardingSphereRule> rules, SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        ShardingSphereSchema currentSchema = this.getCurrentSchema(sqlStatementContext, database);
        for (Map.Entry entry : OrderedSPILoader.getServices(SupportedSQLCheckersBuilder.class, rules).entrySet()) {
            Collection checkers = ((SupportedSQLCheckersBuilder)entry.getValue()).getSupportedSQLCheckers();
            for (SupportedSQLChecker<?, SQLStatementContext> supportedSQLChecker : checkers) {
                if (!supportedSQLChecker.isCheck(sqlStatementContext)) continue;
                supportedSQLChecker.check((SQLStatementContext)((ShardingSphereRule)entry.getKey()), database, currentSchema, sqlStatementContext);
            }
        }
    }

    private ShardingSphereSchema getCurrentSchema(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        ShardingSphereSchema defaultSchema = database.getSchema(new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(database.getName()));
        return sqlStatementContext.getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElse(defaultSchema);
    }
}

