/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.distsql.parser.core;

import java.util.Collection;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.broadcast.distsql.statement.CreateBroadcastTableRuleStatement;
import org.apache.shardingsphere.broadcast.distsql.statement.DropBroadcastTableRuleStatement;
import org.apache.shardingsphere.broadcast.distsql.statement.ShowBroadcastTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.autogen.BroadcastDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.BroadcastDistSQLStatementParser;
import org.apache.shardingsphere.distsql.statement.type.rql.rule.database.CountRuleStatement;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.FromDatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.util.IdentifierValueUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class BroadcastDistSQLStatementVisitor
extends BroadcastDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitCreateBroadcastTableRule(BroadcastDistSQLStatementParser.CreateBroadcastTableRuleContext ctx) {
        return new CreateBroadcastTableRuleStatement(null != ctx.ifNotExists(), (Collection)ctx.tableName().stream().map(IdentifierValueUtils::getValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropBroadcastTableRule(BroadcastDistSQLStatementParser.DropBroadcastTableRuleContext ctx) {
        Collection tableNames = ctx.tableName().stream().map(IdentifierValueUtils::getValue).collect(Collectors.toList());
        return new DropBroadcastTableRuleStatement(null != ctx.ifExists(), tableNames);
    }

    @Override
    public ASTNode visitShowBroadcastTableRules(BroadcastDistSQLStatementParser.ShowBroadcastTableRulesContext ctx) {
        return new ShowBroadcastTableRulesStatement(null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName())));
    }

    @Override
    public ASTNode visitCountBroadcastRule(BroadcastDistSQLStatementParser.CountBroadcastRuleContext ctx) {
        return new CountRuleStatement(null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName())), "BROADCAST");
    }

    @Override
    public ASTNode visitDatabaseName(BroadcastDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }
}

