/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;

final class UrlConversions {
    private UrlConversions() {
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        URL url = (URL)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("URL", url.toString());
        return target;
    }

    static URI toURI(Object from, Converter converter) {
        URL url = (URL)from;
        try {
            return url.toURI();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert URL to URI, input URL: " + url, e);
        }
    }

    static File toFile(Object from, Converter converter) {
        URL url = (URL)from;
        try {
            URI uri = url.toURI();
            return new File(uri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert URL to File, input URL: " + url, e);
        }
    }

    static Path toPath(Object from, Converter converter) {
        URL url = (URL)from;
        try {
            URI uri = url.toURI();
            return Paths.get(uri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert URL to Path, input URL: " + url, e);
        }
    }
}

