/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.oracle.jdbcurl;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.database.connector.core.exception.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;

public final class OracleConnectionPropertiesParser
implements ConnectionPropertiesParser {
    private static final int DEFAULT_PORT = 1521;
    private static final int THIN_MATCH_GROUP_COUNT = 5;
    private static final Pattern THIN_URL_PATTERN = Pattern.compile("jdbc:oracle:(thin|oci|kprb):@(//)?([\\w\\-\\.]+):?(\\d*)[:/]([\\w\\-]+)", 2);
    private static final Pattern CONNECT_DESCRIPTOR_URL_PATTERN = Pattern.compile("jdbc:oracle:(thin|oci|kprb):@[(\\w\\s=)]+HOST\\s*=\\s*([\\w\\-\\.]+).*PORT\\s*=\\s*(\\d+).*SERVICE_NAME\\s*=\\s*(\\w+)\\)");

    public ConnectionProperties parse(String url, String username, String catalog) {
        List<Matcher> matchers = Arrays.asList(THIN_URL_PATTERN.matcher(url), CONNECT_DESCRIPTOR_URL_PATTERN.matcher(url));
        Matcher matcher = matchers.stream().filter(Matcher::find).findAny().orElseThrow(() -> new UnrecognizedDatabaseURLException(url, THIN_URL_PATTERN.pattern()));
        int groupCount = matcher.groupCount();
        return 5 == groupCount ? this.getThinConnectionProperties(username, matcher) : this.getStandardConnectionProperties(username, matcher);
    }

    private ConnectionProperties getThinConnectionProperties(String username, Matcher matcher) {
        return new ConnectionProperties(matcher.group(3), Strings.isNullOrEmpty((String)matcher.group(4)) ? 1521 : Integer.parseInt(matcher.group(4)), matcher.group(5), username, new Properties());
    }

    private ConnectionProperties getStandardConnectionProperties(String username, Matcher matcher) {
        return new ConnectionProperties(matcher.group(2), Strings.isNullOrEmpty((String)matcher.group(3)) ? 1521 : Integer.parseInt(matcher.group(3)), matcher.group(4), username, new Properties());
    }

    public String getDatabaseType() {
        return "Oracle";
    }
}

