/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.close;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.close.PostgreSQLCloseCompletePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.close.PostgreSQLComClosePacket;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PortalContext;

public final class PostgreSQLComCloseExecutor
implements CommandExecutor {
    private final PortalContext portalContext;
    private final PostgreSQLComClosePacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() throws SQLException {
        switch (this.packet.getType()) {
            case PREPARED_STATEMENT: {
                this.connectionSession.getServerPreparedStatementRegistry().removePreparedStatement((Object)this.packet.getName());
                break;
            }
            case PORTAL: {
                this.portalContext.close(this.packet.getName());
                break;
            }
            default: {
                throw new UnsupportedSQLOperationException(this.packet.getType().name());
            }
        }
        return Collections.singleton(new PostgreSQLCloseCompletePacket());
    }

    @Generated
    public PostgreSQLComCloseExecutor(PortalContext portalContext, PostgreSQLComClosePacket packet, ConnectionSession connectionSession) {
        this.portalContext = portalContext;
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

