/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.executors;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdBlobRegistry;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdOpenBlobCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBlobBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdGenericResponsePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.FirebirdStatementIdGenerator;

public final class FirebirdOpenBlobCommandExecutor
implements CommandExecutor {
    private final FirebirdOpenBlobCommandPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() {
        byte[] blobContent = FirebirdBlobBinaryProtocolValue.getBlobContent((long)this.packet.getBlobId());
        FirebirdBlobRegistry.setSegment((byte[])(blobContent == null ? new byte[]{} : blobContent));
        int statementId = FirebirdStatementIdGenerator.getInstance().nextStatementId(this.connectionSession.getConnectionId());
        return Collections.singleton(new FirebirdGenericResponsePacket().setHandle(statementId).setId(this.packet.getBlobId()));
    }

    @Generated
    public FirebirdOpenBlobCommandExecutor(FirebirdOpenBlobCommandPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

